<?php
/**
 * Tags
 *
 * @package     AutomatorWP\Restrict Content\Tags
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Friendship tags
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_restrict_content_get_access_level_tags() {

    return array(
        'access_level_id' => array(
            'label'     => __( 'Access Level ID', 'automatorwp-pro' ),
            'type'      => 'integer',
            'preview'   => '123',
        ),
        'access_level_name' => array(
            'label'     => __( 'Level name', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'Subscribers',
        ),
    );

}

/**
 * Custom action response tag replacement
 *
 * @since 1.0.0
 *
 * @param string    $replacement    The tag replacement
 * @param string    $tag_name       The tag name (without "{}")
 * @param stdClass  $action         The action object
 * @param int       $user_id        The user ID
 * @param string    $content        The content to parse
 * @param stdClass  $log            The last action log object
 *
 * @return string
 */
function automatorwp_restrict_content_get_trigger_access_level_tag_replacement( $replacement, $tag_name, $trigger, $user_id, $content, $log ) {


    $trigger_args = automatorwp_get_trigger( $trigger->type );

    // Skip if trigger is not from this integration
    if( $trigger_args['integration'] !== 'restrict_content' ) {
        return $replacement;
    }

    $access_level_id = automatorwp_get_log_meta( $log->id, 'access_level_id', true );
    $access_level = automatorwp_restrict_content_get_access_level_by_id( $access_level_id );
    
    switch( $tag_name ) {
        case 'access_level_id':
            $replacement = $access_level->id;
            break;
        case 'access_level_name':
            $replacement = $access_level->name;
            break;
    }

    return $replacement;

}
add_filter( 'automatorwp_get_trigger_tag_replacement', 'automatorwp_restrict_content_get_trigger_access_level_tag_replacement', 10, 6 );
