<?php
/**
 * Ajax Functions
 *
 * @package     AutomatorWP\Restrict_Content\Ajax_Function
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Ajax function to add a user to access level
 *
 * @since 1.0.0
 */
function automatorwp_restrict_content_ajax_add_user_to_access_level() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    // Security check
    if( ! current_user_can( automatorwp_get_manager_capability() ) )
        wp_send_json_error( __( 'You are not allowed to perform this action.', 'automatorwp-users-levels' ) );

    // Setup vars
    $access_level_id = absint( $_REQUEST['access_level_id'] );
    $user_id = absint( $_REQUEST['user_id'] );

    // Check all vars
    if( $access_level_id === 0 )
        wp_send_json_error( __( 'Wrong level ID.', 'automatorwp-users-levels' ) );

    if( $user_id === 0 )
        wp_send_json_error( __( 'Wrong user ID.', 'automatorwp-users-levels' ) );

    $result = automatorwp_restrict_content_add_user_to_access_level( $user_id, $access_level_id );

    if( ! $result ) {
        wp_send_json_error( __( 'User is already on level.', 'automatorwp-users-levels' ) );
    }

    wp_send_json_success( __( 'User added to access level successfully!', 'automatorwp-users-levels' ) );

}
add_action( 'wp_ajax_automatorwp_restrict_content_add_user_to_access_level', 'automatorwp_restrict_content_ajax_add_user_to_access_level' );

/**
 * Ajax function to remove a user from level
 *
 * @since 1.0.0
 */
function automatorwp_restrict_content_ajax_remove_user_from_access_level() {
    
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    // Security check
    if( ! current_user_can( automatorwp_get_manager_capability() ) )
        wp_send_json_error( __( 'You are not allowed to perform this action.', 'automatorwp-users-levels' ) );

    // Setup vars
    $access_level_id = absint( $_REQUEST['access_level_id'] );
    $user_id = absint( $_REQUEST['user_id'] );

    // Check all vars
    if( $access_level_id === 0 )
        wp_send_json_error( __( 'Wrong level ID.', 'automatorwp-users-levels' ) );

    if( $user_id === 0 )
        wp_send_json_error( __( 'Wrong user ID.', 'automatorwp-users-levels' ) );

    $result = automatorwp_restrict_content_remove_user_from_access_level( $user_id, $access_level_id );

    if( ! $result ) {
        wp_send_json_error( __( 'User is not on level anymore.', 'automatorwp-users-levels' ) );
    }

    wp_send_json_success( __( 'User removed from level successfully!', 'automatorwp-users-levels' ) );

}
add_action( 'wp_ajax_automatorwp_restrict_content_remove_user_from_access_level', 'automatorwp_restrict_content_ajax_remove_user_from_access_level' );

/**
 * Ajax function for selecting contents
 *
 * @since 1.0.0
 */
function automatorwp_restrict_content_ajax_get_access_levels() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    global $wpdb;

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? $wpdb->esc_like( sanitize_text_field( $_REQUEST['q'] ) ) : '';

    $access_levels = automatorwp_restrict_content_get_access_levels();
    
    $results = array();

    // Parse levels results to match select2 results
    foreach ( $access_levels as $access_level ) {

        if( ! empty( $search ) ) {
            if( strpos( strtolower( $access_level['name'] ), strtolower( $search ) ) === false ) {
                continue;
            }
        }

        $results[] = array(
            'id'   => $access_level['id'],
            'text' => $access_level['name']
        );
    }

    // Prepend option none
    $results = automatorwp_ajax_get_ajax_results_option_none( $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_restrict_content_get_access_levels', 'automatorwp_restrict_content_ajax_get_access_levels' );