(function ( $ ) {

    // Slug
    var input = $('.automatorwp-restrict-content-form input[name="name"]');

    input.on("keyup", function () {
        var slug = $(this).val().toLowerCase().replace(/[^a-z0-9_-]/g, '_');

        // Update slug field
        $('.automatorwp-restrict-content-form input[name="slug"]').val(slug);

        // Update slug preview
        $('.automatorwp-restrict-content-user-levels-slug').html(slug);

        // Update shortcode field
        var shortcode = automatorwp_restrict_content_access_levels_admin.shortcode_pattern.replace('SLUG', slug);
        $('.automatorwp-restrict-content-shortcode-input').val(shortcode);

    });

    // On click remove user from level
    $('body').on('click', '.automatorwp-restrict-content-remove-user-button', function(e) {
        e.preventDefault();

        var $this = $(this);
        var url = $this.attr('href');
        var tr = $this.closest('tr');

        var user_id = $this.data('user-id');

        if( $this.hasClass('disabled') ) {
            return;
        }

        // Disable the button
        $this.addClass('disabled');

        // Call the URL to remove the item
        $.ajax({
            url: automatorwp_restrict_content_access_levels_admin.ajaxurl,
            data: {
                action: 'automatorwp_restrict_content_remove_user_from_access_level',
                nonce: automatorwp_restrict_content_access_levels_admin.nonce,
                access_level_id: $('#ct_edit_form input#object_id').val(),
                user_id: user_id,
            },
            success: function( response ) {
                $('.automatorwp-access-level-add-user-message').html(response.data);
                automatorwp_restrict_content_refresh_ajax_table();

                // Restore the button
                $this.removeClass('disabled');
            }
        });

    });

    // User Selector Control
    $('.automatorwp-user-selector select').each(function() { automatorwp_user_selector( $(this) ); });

    // On click remove user from level
    $('body').on('click', '.automatorwp-restrict-content-add-user-button', function(e) {
        e.preventDefault();

        var $this = $(this);

        var user_id = $('select#automatorwp-restrict-content-user-id').val();

        if( user_id === null ) {
            $('.automatorwp-access-level-add-user-message').html( automatorwp_restrict_content_access_levels_admin.no_user_selected );
            return;
        }

        if( $this.hasClass('disabled') ) {
            return;
        }

        $('.automatorwp-access-level-add-user-message').html('');

        // Disable the button
        $this.addClass('disabled');

        $.ajax({
            url: automatorwp_restrict_content_access_levels_admin.ajaxurl,
            data: {
                action: 'automatorwp_restrict_content_add_user_to_access_level',
                nonce: automatorwp_restrict_content_access_levels_admin.nonce,
                access_level_id: $('#ct_edit_form input#object_id').val(),
                user_id: user_id,
            },
            success: function( response ) {

                $('.automatorwp-access-level-add-user-message').html(response.data);

                automatorwp_restrict_content_refresh_ajax_table();

                // Restore the button
                $this.removeClass('disabled');
            }
        });

    });

    function automatorwp_restrict_content_refresh_ajax_table() {

        var $ = $ || jQuery;

        var table = $('.ct-ajax-list-table[data-object="automatorwp_restrict_content_access_level_users"]');

        // Refresh the table
        ct_ajax_list_table_paginate_table( table, table.find('input#current-page-selector').val() );

    }

})( jQuery );