<?php
/**
 * Change Group Cover
 *
 * @package     AutomatorWP\Integrations\PeepSo\Triggers\Change_Group_Cover
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_PeepSo_Change_Group_Cover extends AutomatorWP_Integration_Trigger {

    public $integration = 'peepso';
    public $trigger = 'peepso_change_group_cover';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User changes the group cover image', 'automatorwp-pro' ),
            'select_option'     => __( 'User changes the group <strong>cover image</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User changes the group cover image %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User changes the group cover image', 'automatorwp-pro' ),
            'action'            => 'peepso_groups_after_change_cover',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 1,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int $group_id The group ID
     */
    public function listener( $group_id ) {

        $user_id = get_current_user_id();
        
        // Trigger change group cover
        automatorwp_trigger_event( array(
            'trigger'           => $this->trigger,
            'user_id'           => $user_id,
            'post_id'           => $group_id,
        ) );

    }

}

new AutomatorWP_PeepSo_Change_Group_Cover();