<?php
/**
 * Change Cover Image
 *
 * @package     AutomatorWP\Integrations\PeepSo\Triggers\Change_Cover_Image
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_PeepSo_Change_Cover_Image extends AutomatorWP_Integration_Trigger {

    public $integration = 'peepso';
    public $trigger = 'peepso_change_cover_image';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User changes his cover image', 'automatorwp-pro' ),
            'select_option'     => __( 'User changes his <strong>cover image</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User changes his cover image %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User changes his cover image', 'automatorwp-pro' ),
            'action'            => 'peepso_user_after_change_cover',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 1,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int $user_id
     */
    public function listener( $user_id ) {

        // Trigger cover image change
        automatorwp_trigger_event( array(
            'trigger'           => $this->trigger,
            'user_id'           => $user_id,
        ) );

    }

}

new AutomatorWP_PeepSo_Change_Cover_Image();