<?php
/**
 * Add User Activity
 *
 * @package     AutomatorWP\Integrations\PeepSo\Actions\Add_User_Activity
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_PeepSo_Add_User_Activity extends AutomatorWP_Integration_Action {

    public $integration = 'peepso';
    public $action = 'peepso_add_user_activity';

    /**
     * Store the action result
     *
     * @since 1.0.0
     *
     * @var string $result
     */
    public $result = '';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Add an activity to the user', 'automatorwp-pro' ),
            'select_option'     => __( 'Add an <strong>activity</strong> to the user', 'automatorwp-pro' ),
            /* translators: %1$s: Activity. */
            'edit_label'        => sprintf( __( 'Add an %1$s to the user', 'automatorwp-pro' ), '{activity}' ),
            /* translators: %1$s: Activity. */
            'log_label'         => sprintf( __( 'Add an %1$s to the user', 'automatorwp-pro' ), '{activity}' ),
            'options'           => array(
                'activity' => array(
                    'default' => __( 'activity', 'automatorwp-pro' ),
                    'fields' => array(
                        'content' => array(
                            'name' => __( 'Content:', 'automatorwp-pro' ),
                            'desc' => __( 'Activity\'s content.', 'automatorwp-pro' ),
                            'type' => 'wysiwyg',
                            'default' => ''
                        ),
                        'access' => array(
                            'name' => __( 'Access:', 'automatorwp-pro' ),
                            'desc' => __( 'Activity\'s access permission.', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options' => array(
                                'public' => __( 'For everyone', 'automatorwp-pro' ),
                                'members' => __( 'Only members', 'automatorwp-pro' ),
                                'private' => __( 'Private', 'automatorwp-pro' ),
                            ),
                            'default' => 'public'
                        ),
                    )
                )
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        $this->result = '';

        if( ! class_exists( 'PeepSoActivity' ) ) {
            $this->result = __( 'Class PeepSoActivity not found.', 'automatorwp-pro' );
            return;
        }

        // Shorthand
        $content            = $action_options['content'];
        $access             = $action_options['access'];

        $PeepSoActivity = PeepSoActivity::get_instance();

        $extra = array(
            'module_id' => 1000,
            'show_preview' => 0,
        );

        // const ACCESS_PUBLIC = 10;
        // const ACCESS_MEMBERS = 20;
        // const ACCESS_PRIVATE = 40;
        switch ( $access ) {
            case 'members':
                $extra['act_access'] = 20;
                break;
            case 'private':
                $extra['act_access'] = 40;
                break;
            case 'public':
            default:
                $extra['act_access'] = 10;
                break;
        }

        $user_wall_id = $user_id;
        $activity_author_id = $user_id;

        $result = $PeepSoActivity->add_post( $user_wall_id, $activity_author_id, $content, $extra );

        if( $result ) {
            $this->result = __( 'Activity added successfully.', 'automatorwp-pro' );
        } else {
            $this->result = __( 'Activity not added.', 'automatorwp-pro' );
        }

    }

    /**
     * Register required hooks
     *
     * @since 1.0.0
     */
    public function hooks() {

        // Log meta data
        add_filter( 'automatorwp_user_completed_action_log_meta', array( $this, 'log_meta' ), 10, 5 );

        // Log fields
        add_filter( 'automatorwp_log_fields', array( $this, 'log_fields' ), 10, 5 );

        parent::hooks();

    }

    /**
     * Action custom log meta
     *
     * @since 1.0.0
     *
     * @param array     $log_meta           Log meta data
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     *
     * @return array
     */
    public function log_meta( $log_meta, $action, $user_id, $action_options, $automation ) {

        // Bail if action type don't match this action
        if( $action->type !== $this->action ) {
            return $log_meta;
        }

        $log_meta['result'] = $this->result;

        return $log_meta;

    }

    /**
     * Action custom log fields
     *
     * @since 1.0.0
     *
     * @param array     $log_fields The log fields
     * @param stdClass  $log        The log object
     * @param stdClass  $object     The trigger/action/automation object attached to the log
     *
     * @return array
     */
    public function log_fields( $log_fields, $log, $object ) {

        // Bail if log is not assigned to an action
        if( $log->type !== 'action' ) {
            return $log_fields;
        }

        // Bail if action type don't match this action
        if( $object->type !== $this->action ) {
            return $log_fields;
        }

        $log_fields['result'] = array(
            'name' => __( 'Result:', 'automatorwp-pro' ),
            'type' => 'text',
        );

        return $log_fields;

    }

}

new AutomatorWP_PeepSo_Add_User_Activity();