<?php
/**
 * Scripts
 *
 * @package     AutomatorWP\Integrations\Modern_Events_Calendar\Scripts
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_modern_events_calendar_admin_register_scripts() {

    // Use minified libraries if SCRIPT_DEBUG is turned off
    $suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    // Scripts
    wp_register_script( 'automatorwp-modern-events-calendar-js', AUTOMATORWP_MODERN_EVENTS_CALENDAR_URL . 'assets/js/automatorwp-modern-events-calendar' . $suffix . '.js', array( 'jquery', 'jquery-ui-dialog' ), AUTOMATORWP_MODERN_EVENTS_CALENDAR_VER, true );

}
add_action( 'admin_init', 'automatorwp_modern_events_calendar_admin_register_scripts' );

/**
 * Enqueue admin scripts
 *
 * @since       1.0.0
 *
 * @param string $hook
 *
 * @return      void
 */
function automatorwp_modern_events_calendar_admin_enqueue_scripts( $hook ) {

    // Scripts
    wp_enqueue_script( 'automatorwp-modern-events-calendar-js' );

}
add_action( 'admin_enqueue_scripts', 'automatorwp_modern_events_calendar_admin_enqueue_scripts' );