<?php
/**
 * Plugin Name:           AutomatorWP - Link
 * Plugin URI:            https://automatorwp.com/add-ons/link/
 * Description:           New triggers based on link clicks generated by [automatorwp_link].
 * Version:               1.0.3
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-link
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.6
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Link
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Link {

    /**
     * @var         AutomatorWP_Link $instance The one true AutomatorWP_Link
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Link self::$instance The one true AutomatorWP_Link
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Link();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_LINK_VER', '1.0.3' );

        // Plugin file
        define( 'AUTOMATORWP_LINK_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_LINK_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_LINK_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Triggers
            require_once AUTOMATORWP_LINK_DIR . 'includes/triggers/click-link.php';

            // Includes
            require_once AUTOMATORWP_LINK_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_LINK_DIR . 'includes/scripts.php';
            require_once AUTOMATORWP_LINK_DIR . 'includes/shortcodes.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Link instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Link The one true AutomatorWP_Link
 */
function AutomatorWP_Link() {
    return AutomatorWP_Link::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Link' );
