<?php
/**
 * Earn Certificate
 *
 * @package     AutomatorWP\Integrations\LifterLMS\Triggers\Earn_Certificate
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_LifterLMS_Earn_Certificate extends AutomatorWP_Integration_Trigger {

    public $integration = 'lifterlms';
    public $trigger = 'lifterlms_earn_certificate';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User earns a certificate', 'automatorwp-pro' ),
            'select_option'     => __( 'User earns <strong>a certificate</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Post title. %2$s: Number of times. */
            'edit_label'        => sprintf( __( 'User earns %1$s %2$s time(s)', 'automatorwp-pro' ), '{post}', '{times}' ),
            /* translators: %1$s: Post title. */
            'log_label'         => sprintf( __( 'User earns %1$s', 'automatorwp-pro' ), '{post}' ),
            'action'            => 'llms_user_earned_certificate',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 3,
            'options'           => array(
                'post' => automatorwp_utilities_post_option( array(
                    'name' => __( 'Certificate:', 'automatorwp-pro' ),
                    'option_none_label' => __( 'any certificate', 'automatorwp-pro' ),
                    'post_type' => 'llms_certificate'
                ) ),
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_post_tags(),
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int   $user_id
     * @param int   $new_user_certificate_id (ID of post of the type 'llms_my_certificate')
     * @param int   $related_post_id
     */
    public function listener( $user_id, $new_user_certificate_id, $related_post_id ) {

        // Main certificate is on '_llms_certificate_template' meta
        $certificate_id = get_post_meta( $new_user_certificate_id, '_llms_certificate_template', true );

        automatorwp_trigger_event( array(
            'trigger'   => $this->trigger,
            'user_id'   => $user_id,
            'post_id'   => $certificate_id,
        ) );

    }

    /**
     * User deserves check
     *
     * @since 1.0.0
     *
     * @param bool      $deserves_trigger   True if user deserves trigger, false otherwise
     * @param stdClass  $trigger            The trigger object
     * @param int       $user_id            The user ID
     * @param array     $event              Event information
     * @param array     $trigger_options    The trigger's stored options
     * @param stdClass  $automation         The trigger's automation object
     *
     * @return bool                          True if user deserves trigger, false otherwise
     */
    public function user_deserves_trigger( $deserves_trigger, $trigger, $user_id, $event, $trigger_options, $automation ) {

        // Don't deserve if post is not received
        if( ! isset( $event['post_id'] ) ) {
            return false;
        }

        // Don't deserve if post doesn't match with the trigger option
        if( ! automatorwp_posts_matches( $event['post_id'], $trigger_options['post'] ) ) {
            return false;
        }

        return $deserves_trigger;

    }

}

new AutomatorWP_LifterLMS_Earn_Certificate();