<?php
/**
 * Mark Lesson
 *
 * @package     AutomatorWP\Integrations\LifterLMS\Actions\Mark_Lesson
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_LifterLMS_Mark_Lesson extends AutomatorWP_Integration_Action {

    public $integration = 'lifterlms';
    public $action = 'lifterlms_mark_lesson';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Mark lesson as completed or not completed', 'automatorwp-pro' ),
            'select_option'     => __( 'Mark lesson as <strong>completed or not completed</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Post title. %2$s: Operation (completed or not completed). */
            'edit_label'        => sprintf( __( 'Mark %1$s as %2$s', 'automatorwp-pro' ), '{post}', '{operation}' ),
            /* translators: %1$s: Post title. %2$s: Operation (completed or not completed). */
            'log_label'         => sprintf( __( 'Mark %1$s as %2$s', 'automatorwp-pro' ), '{post}', '{operation}' ),
            'options'           => array(
                'post' => automatorwp_utilities_post_option( array(
                    'name'              => __( 'Lesson:', 'automatorwp-pro' ),
                    'option_none_label' => __( 'all lessons', 'automatorwp-pro' ),
                    'option_custom'         => true,
                    'option_custom_desc'    => __( 'Lesson ID', 'automatorwp-pro' ),
                    'post_type'         => 'lesson',
                ) ),
                'operation' => array(
                    'from' => 'operation',
                    'fields' => array(
                        'operation' => array(
                            'name' => __( 'Operation:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options' => array(
                                'complete'      => __( 'completed', 'automatorwp-pro' ),
                                'not_complete'  => __( 'not completed', 'automatorwp-pro' ),
                            ),
                            'default' => 'complete'
                        ),
                    )
                ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $operation = $action_options['operation'];
        $lesson_id = $action_options['post'];

        // Ensure operation default value
        if( empty( $operation ) ) {
            $operation = 'complete';
        }

        $lessons = array();

        // Check specific lesson
        if( $lesson_id !== 'any' ) {

            $lesson = get_post( $lesson_id );

            // Bail if lesson doesn't exists
            if( ! $lesson ) {
                return;
            }

            $lessons = array( $lesson_id );

        } else {

            $student = new LLMS_Student( $user_id );
            $user_courses = $student->get_courses( array( 'limit' => 999 ) );

            // Bail if user is not in any course
            if( empty( $user_courses['results'] ) ) {
                return;
            }

            foreach( $user_courses['results'] as $course_id ) {

                // Get the course object to get their sections
                $course = new LLMS_Course( $course_id );
                $sections = $course->get_sections();

                // Loop course sections
                foreach( $sections as $section ) {

                    // Get the section object to get their lessons
                    $section = new LLMS_Section( $section->id );
                    $lessons = $section->get_lessons();

                    // Loop section lessons
                    foreach ( $lessons as $lesson ) {
                        $lessons[] = $lesson->id;
                    }

                }

            }

        }

        switch ( $operation ) {
            case 'complete':
                // Mark lessons as completed
                foreach( $lessons as $lesson_id ) {
                    llms_mark_complete( $user_id, $lesson_id, 'lesson' );
                }
                break;
            case 'not_complete':
                // Mark lessons as no completed
                foreach( $lessons as $lesson_id ) {
                    llms_mark_incomplete( $user_id, $lesson_id, 'lesson' );
                }
                break;
        }

    }

}

new AutomatorWP_LifterLMS_Mark_Lesson();