<?php
/**
 * Mark Course
 *
 * @package     AutomatorWP\Integrations\LifterLMS\Actions\Mark_Course
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_LifterLMS_Mark_Course extends AutomatorWP_Integration_Action {

    public $integration = 'lifterlms';
    public $action = 'lifterlms_mark_course';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Mark course as completed or not completed', 'automatorwp-pro' ),
            'select_option'     => __( 'Mark course as <strong>completed or not completed</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Post title. %2$s: Operation (completed or not completed). */
            'edit_label'        => sprintf( __( 'Mark %1$s as %2$s', 'automatorwp-pro' ), '{post}', '{operation}' ),
            /* translators: %1$s: Post title. %2$s: Operation (completed or not completed). */
            'log_label'         => sprintf( __( 'Mark %1$s as %2$s', 'automatorwp-pro' ), '{post}', '{operation}' ),
            'options'           => array(
                'post' => automatorwp_utilities_post_option( array(
                    'name'              => __( 'Course:', 'automatorwp-pro' ),
                    'option_none_label' => __( 'all courses', 'automatorwp-pro' ),
                    'option_custom'         => true,
                    'option_custom_desc'    => __( 'Course ID', 'automatorwp-pro' ),
                    'post_type'         => 'course',
                ) ),
                'operation' => array(
                    'from' => 'operation',
                    'fields' => array(
                        'operation' => array(
                            'name' => __( 'Operation:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options' => array(
                                'complete'      => __( 'completed', 'automatorwp-pro' ),
                                'not_complete'  => __( 'not completed', 'automatorwp-pro' ),
                            ),
                            'default' => 'complete'
                        ),
                    )
                ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $operation = $action_options['operation'];
        $course_id = $action_options['post'];

        // Ensure operation default value
        if( empty( $operation ) ) {
            $operation = 'complete';
        }

        $courses = array();

        // Check specific course
        if( $course_id !== 'any' ) {

            $course = get_post( $course_id );

            // Bail if course doesn't exists
            if( ! $course ) {
                return;
            }

            $courses = array( $course_id );

        } else {

            $student = new LLMS_Student( $user_id );
            $user_courses = $student->get_courses( array( 'limit' => 999 ) );

            // Bail if user is not in any course
            if( empty( $user_courses['results'] ) ) {
                return;
            }

            $courses = $user_courses['results'];

        }

        switch ( $operation ) {
            case 'complete':
                // Loop all courses
                foreach( $courses as $course_id ) {

                    // Get the course object to get their sections
                    $course = new LLMS_Course( $course_id );
                    $sections = $course->get_sections();

                    // Loop course sections
                    foreach( $sections as $section ) {

                        // Get the section object to get their lessons
                        $section = new LLMS_Section( $section->id );
                        $lessons = $section->get_lessons();

                        // Loop section lessons
                        foreach ( $lessons as $lesson ) {
                            // Mark lesson as completed
                            llms_mark_complete( $user_id, $lesson->id, 'lesson' );
                        }

                        // Mark section as completed
                        llms_mark_complete( $user_id, $section->id, 'section' );

                    }

                    // Mark courses as completed
                    llms_mark_complete( $user_id, $course_id, 'course' );
                }
                break;
            case 'not_complete':
                // Loop all courses
                foreach( $courses as $course_id ) {

                    // Get the course object to get their sections
                    $course = new LLMS_Course( $course_id );
                    $sections = $course->get_sections();

                    // Loop course sections
                    foreach( $sections as $section ) {

                        // Get the section object to get their lessons
                        $section = new LLMS_Section( $section->id );
                        $lessons = $section->get_lessons();

                        // Loop section lessons
                        foreach ( $lessons as $lesson ) {
                            // Mark lesson as not completed
                            llms_mark_incomplete( $user_id, $lesson->id, 'lesson' );
                        }

                        // Mark section as not completed
                        llms_mark_incomplete( $user_id, $section->id, 'section' );

                    }

                    // Mark courses  as not completed
                    llms_mark_incomplete( $user_id, $course_id, 'course' );
                }
                break;
        }

    }

}

new AutomatorWP_LifterLMS_Mark_Course();