<?php
/**
 * Plugin Name:           AutomatorWP - LearnDash
 * Plugin URI:            https://automatorwp.com/add-ons/learndash/
 * Description:           Connect AutomatorWP with LearnDash.
 * Version:               1.2.6
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-learndash
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.7
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\LearnDash
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_LearnDash {

    /**
     * @var         AutomatorWP_LearnDash $instance The one true AutomatorWP_LearnDash
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_LearnDash self::$instance The one true AutomatorWP_LearnDash
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_LearnDash();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_LEARNDASH_VER', '1.2.6' );

        // Plugin file
        define( 'AUTOMATORWP_LEARNDASH_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_LEARNDASH_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_LEARNDASH_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Triggers
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/view-quiz.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/view-lesson.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/view-topic.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/view-course.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/complete-quiz.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/complete-quiz-percentage.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/complete-quiz-percentage-between.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/complete-topic.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/complete-topic-category.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/complete-topic-tag.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/complete-lesson.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/complete-lesson-category.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/complete-lesson-tag.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/enroll-course.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/enroll-course-category.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/enroll-course-tag.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/complete-course.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/complete-course-category.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/complete-course-tag.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/add-group.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/upload-assignment.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/approve-assignment.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/submit-essay.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/incomplete-topic.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/triggers/incomplete-lesson.php';

            // Actions
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/actions/reset-quiz.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/actions/mark-topic.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/actions/mark-lesson.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/actions/mark-lesson-assignments.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/actions/mark-course-assignments.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/actions/user-course.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/actions/mark-course.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/actions/reset-course.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/actions/create-group.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/actions/user-group.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/actions/user-group-leader.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/actions/email-groups-leaders.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/actions/email-certificate.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/actions/user-course-extend-access.php';

            // Filters
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/filters/user-has-completed-course.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/filters/user-has-not-completed-course.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/filters/user-is-added-group.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/filters/user-is-not-added-group.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/filters/user-is-enrolled-course.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/filters/user-is-not-enrolled-course.php';

            // Includes
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_LEARNDASH_DIR . 'includes/tags.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'learndash', array(
            'label' => 'LearnDash',
            'icon'  => AUTOMATORWP_LEARNDASH_URL . 'assets/learndash.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! class_exists( 'SFWD_LMS' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_LearnDash instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_LearnDash The one true AutomatorWP_LearnDash
 */
function AutomatorWP_LearnDash() {
    return AutomatorWP_LearnDash::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_LearnDash' );
