<?php
/**
 * Reset Quiz
 *
 * @package     AutomatorWP\Integrations\LearnDash\Actions\Reset_Quiz
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_LearnDash_Reset_Quiz extends AutomatorWP_Integration_Action {

    public $integration = 'learndash';
    public $action = 'learndash_reset_quiz';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Reset quiz attempts', 'automatorwp-pro' ),
            'select_option'     => __( 'Reset <strong>quiz attempts</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Post title. */
            'edit_label'        => sprintf( __( 'Reset %1$s attempts', 'automatorwp-pro' ), '{post}' ),
            /* translators: %1$s: Post title. */
            'log_label'         => sprintf( __( 'Reset %1$s attempts', 'automatorwp-pro' ), '{post}' ),
            'options'           => array(
                'post' => automatorwp_utilities_post_option( array(
                    'name'              => __( 'Quiz:', 'automatorwp-pro' ),
                    'option_none_label' => __( 'all quizzes', 'automatorwp-pro' ),
                    'option_custom'         => true,
                    'option_custom_desc'    => __( 'Quiz ID', 'automatorwp-pro' ),
                    'post_type'         => 'sfwd-quiz',
                ) ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $quiz_id = $action_options['post'];

        $quizzes = array();

        // Check specific quiz
        if( $quiz_id !== 'any' ) {

            $quiz = get_post( $quiz_id );

            // Bail if quiz doesn't exists
            if( ! $quiz ) {
                return;
            }

            $quizzes = array( $quiz_id );

        } else {

            // Get all user quizzes
            $quizzes = get_user_meta( $user_id, '_sfwd-quizzes', true );

        }

        // Reset quizzes attempts
        foreach( $quizzes as $quiz_id ) {
            learndash_delete_quiz_progress( $user_id, $quiz_id );
        }

    }

}

new AutomatorWP_LearnDash_Reset_Quiz();