<?php
/**
 * Delete User
 *
 * @package     AutomatorWP\Integrations\Jetpack_CRM\Actions\Delete_User
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Jetpack_CRM_Delete_User extends AutomatorWP_Integration_Action {

    public $integration = 'jetpack_crm';
    public $action = 'jetpack_crm_delete_user';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Delete user from contact list', 'automatorwp-pro' ),
            'select_option'     => __( 'Delete <strong>user</strong> from contact list', 'automatorwp-pro' ),
            'edit_label'        => __( 'Delete user from contact list', 'automatorwp-pro' ),
            'log_label'         => __( 'Delete user from contact list', 'automatorwp-pro' ),
            'options'           => array(
                // No options
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        $user = get_user_by ( 'ID', $user_id );

        $user_email = array (
            'email' => $user->user_email
        );

        $obj_contact = new zbsDAL_contacts;

        /**
         * Get contact ID from Jetpack CRM
         * @param null  The contact ID
         * @param array The user email to search
         */
        $contact = $obj_contact->getContact( null, $user_email );

        $args_contact = array(
            'id' => $contact['id']
        );

        $contact_deleted = $obj_contact->deleteContact( $args_contact );
        
        $this->result = sprintf( __( '%s removed from Contact list', 'automatorwp-pro' ), $user->user_email );

    }

    /**
     * Register required hooks
     *
     * @since 1.0.0
     */
    public function hooks() {

        // Log meta data
        add_filter( 'automatorwp_user_completed_action_log_meta', array( $this, 'log_meta' ), 10, 5 );

        // Log fields
        add_filter( 'automatorwp_log_fields', array( $this, 'log_fields' ), 10, 5 );

        parent::hooks();

    }

    /**
     * Action custom log meta
     *
     * @since 1.0.0
     *
     * @param array     $log_meta           Log meta data
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     *
     * @return array
     */
    public function log_meta( $log_meta, $action, $user_id, $action_options, $automation ) {

        // Bail if action type don't match this action
        if( $action->type !== $this->action ) {
            return $log_meta;
        }

        // Store the action's result
        $log_meta['result'] = $this->result;

        return $log_meta;
    }

    /**
     * Action custom log fields
     *
     * @since 1.0.0
     *
     * @param array     $log_fields The log fields
     * @param stdClass  $log        The log object
     * @param stdClass  $object     The trigger/action/automation object attached to the log
     *
     * @return array
     */
    public function log_fields( $log_fields, $log, $object ) {

        // Bail if log is not assigned to an action
        if( $log->type !== 'action' ) {
            return $log_fields;
        }

        // Bail if action type don't match this action
        if( $object->type !== $this->action ) {
            return $log_fields;
        }

        $log_fields['result'] = array(
            'name' => __( 'Result:', 'automatorwp-pro' ),
            'type' => 'text',
        );

        return $log_fields;
    }

}

new AutomatorWP_Jetpack_CRM_Delete_User();