<?php
/**
 * Scripts
 *
 * @package     AutomatorWP\Integrations\Instagram\Scripts
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_instagram_admin_register_scripts() {

    // Use minified libraries if SCRIPT_DEBUG is turned off
    $suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    // Stylesheets
    wp_register_style( 'automatorwp-instagram-css', AUTOMATORWP_INSTAGRAM_URL . 'assets/css/automatorwp-instagram' . $suffix . '.css', array(), AUTOMATORWP_INSTAGRAM_VER, 'all' );

    // Scripts
    wp_register_script( 'automatorwp-instagram-js', AUTOMATORWP_INSTAGRAM_URL . 'assets/js/automatorwp-instagram' . $suffix . '.js', array( 'jquery' ), AUTOMATORWP_INSTAGRAM_VER, true );

}
add_action( 'admin_init', 'automatorwp_instagram_admin_register_scripts' );

/**
 * Enqueue admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_instagram_admin_enqueue_scripts( $hook ) {

    // Stylesheets
    wp_enqueue_style( 'automatorwp-instagram-css' );

    wp_localize_script( 'automatorwp-instagram-js', 'automatorwp_instagram', array(
        'nonce' => automatorwp_get_admin_nonce(),
    ) );

    wp_enqueue_script( 'automatorwp-instagram-js' );

}
add_action( 'admin_enqueue_scripts', 'automatorwp_instagram_admin_enqueue_scripts', 100 );