<?php
/**
 * Cron
 *
 * @package     AutomatorWP\Integrations\Instagram
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

require_once AUTOMATORWP_INSTAGRAM_DIR . 'includes/cron/refresh-token.php';

/**
 * Register custom cron schedules
 *
 * @since 1.0.0
 *
 * @param array $schedules
 *
 * @return array
 */
function automatorwp_instagram_cron_schedules( $schedules ) {

    $schedules['every_month'] = array(
        'interval' => 2592000,
        'display'  => __( 'Every month', 'automatorwp' ),
    );

    return $schedules;

}
add_filter( 'cron_schedules', 'automatorwp_instagram_cron_schedules' );

/**
 * Register schedule events
 *
 * @since 1.3.2
 */
function automatorwp_instagram_schedule_events() {

    /**
     * Action triggered on activation to schedule events
     *
     * @since 1.3.2
     */
    do_action( 'automatorwp_instagram_schedule_events' );

}