<?php
/**
 * Scripts
 *
 * @package     AutomatorWP\HubSpot\Scripts
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_hubspot_admin_register_scripts() {

    // Use minified libraries if SCRIPT_DEBUG is turned off
    $suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    // Stylesheets
    wp_register_style( 'automatorwp-hubspot-css', AUTOMATORWP_HUBSPOT_URL . 'assets/css/automatorwp-hubspot' . $suffix . '.css', array(), AUTOMATORWP_HUBSPOT_VER, 'all' );

}
add_action( 'admin_init', 'automatorwp_hubspot_admin_register_scripts' );

/**
 * Enqueue admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_hubspot_admin_enqueue_scripts( $hook ) {

    // Stylesheets
    wp_enqueue_style( 'automatorwp-hubspot-css' );

}
add_action( 'admin_enqueue_scripts', 'automatorwp_hubspot_admin_enqueue_scripts', 100 );