(function( $ ) {

    var prefix = 'automatorwp-google-calendar-';
    var _prefix = 'automatorwp_google_calendar_';

    // On click authorize button
    $('body').on('click', '.automatorwp_settings #' + _prefix + 'authorize', function(e) {
        e.preventDefault();

        var button = $(this);
        var wrapper = button.parent();

        var client_id = $('#' + _prefix + 'client_id').val();
        var client_secret = $('#' + _prefix + 'client_secret').val();

        // Check if response div exists
        var response_wrap = wrapper.find('#' + _prefix + 'response');

        if( ! response_wrap.length ) {
            wrapper.append( '<div id="' + _prefix + 'response" style="display: none; margin-top: 10px;"></div>' );
            response_wrap = wrapper.find('#' + _prefix + 'response');
        }

        // Show error message if not correctly configured
        if( client_id.length === 0 || client_secret.length === 0 ) {
            response_wrap.addClass( 'automatorwp-notice-error' );
            response_wrap.html( 'All fields are required to connect with Google Calendar' );
            response_wrap.slideDown('fast');
            return;
        }

        response_wrap.slideUp('fast');
        response_wrap.attr('class', '');

        // Show spinner
        wrapper.append('<span class="spinner is-active" style="float: none;"></span>');

        // Disable button
        button.prop('disabled', true);

        $.post(
            ajaxurl,
            {
                action: 'automatorwp_google_calendar_authorize',
                nonce: automatorwp_google_calendar.nonce,
                client_id: client_id,
                client_secret: client_secret,
            },
            function( response ) {

                // Add class automatorwp-notice-success on successful unlock, if not will add the class automatorwp-notice-error
                response_wrap.addClass( 'automatorwp-notice-' + ( response.success === true ? 'success' : 'error' ) );
                response_wrap.html( ( response.data.message !== undefined ? response.data.message : response.data ) );
                response_wrap.slideDown('fast');

                // Hide spinner
                wrapper.find('.spinner').remove();

                // Redirect on success
                if( response.success === true && response.data.redirect_url !== undefined ) {
                    window.location = response.data.redirect_url;
                    return;
                }

                // Enable button
                button.prop('disabled', false);

            }
        );

    });

    // On change calendar
    $('body').on('change', '.automatorwp-action-google-calendar-add-attendee .cmb2-id-calendar select, '
        + '.automatorwp-action-google-calendar-remove-attendee .cmb2-id-calendar select', function(e) {
        var row = $(this).closest('.cmb-row');
        var event_row = row.next('.cmb2-id-event');

        var calendar_id = $(this).val();
        var first_change = row.hasClass('is-option-change');

        if( calendar_id === 'any' || calendar_id === '' ) {
            // Hide the term selector
            if( first_change ) {
                event_row.hide();
            } else {
                event_row.slideUp('fast');
            }
        } else {
            var event_selector = event_row.find('select.select2-hidden-accessible');

            // Remove Select2 element
            event_selector.next('.select2').remove();

            // Update the calendar (since we do not use the table attribute, lets to use it as calendar)
            event_selector.data( 'table', calendar_id );

            // Reset the selector
            event_selector.removeAttr('data-select2-id');

            // Init it again
            automatorwp_ajax_selector( event_selector );

            // Show the term selector
            if( first_change ) {
                event_row.show();
            } else {
                event_row.slideDown('fast');
            }
        }

        row.removeClass('is-option-change');
    });

    // On click on an option, check if form contains the calendar selector
    $('body').on('click', '.automatorwp-automation-item-label > .automatorwp-option', function(e) {

        var item = $(this).closest('.automatorwp-automation-item');
        var option = $(this).data('option');
        var option_form = item.find('.automatorwp-option-form-container[data-option="' + option + '"]');
        var calendar_selector = option_form.find('.cmb2-id-calendar');

        if( calendar_selector !== undefined ) {
            calendar_selector.addClass('is-option-change');
            calendar_selector.find('select.select2-hidden-accessible').trigger('change');
        }

    });


})( jQuery );