<?php
/**
 * Client Get Reply Ticket
 *
 * @package     AutomatorWP\Integrations\Fluent_Support\Triggers\Client_Get_Reply_Ticket
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Fluent_Support_Client_Get_Reply_Ticket extends AutomatorWP_Integration_Trigger {

    public $integration = 'fluent_support';
    public $trigger = 'fluent_support_get_client_reply_ticket';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'Client gets a reply from a ticket', 'automatorwp-pro' ),
            'select_option'     => __( 'Client gets a <strong>reply</strong> from a ticket', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'Client gets a reply from a ticket %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'Client gets a reply from a ticket', 'automatorwp-pro' ),
            'action'            => 'fluent_support/response_added_by_agent',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 3,
            'options'           => array(
                'times' => automatorwp_utilities_times_option()
            ),
            'tags' => array_merge(
                automatorwp_utilities_post_tags( __( 'Ticket', 'automatorwp-pro' ) ),
                automatorwp_utilities_times_tag( )
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param array $response    Replies data
     * @param array $ticket      Tickets data
     * @param object $person     Person data
     */
    public function listener( $response, $ticket, $person ) {
    
        $ticket_id = absint( $ticket['id'] );
        $user_id = absint( $ticket['customer']['user_id'] );

        // Bail if user not found
        if( $user_id === 0 ) {
            return;
        }

        automatorwp_trigger_event( array(
            'trigger' => $this->trigger,
            'post_id' => $ticket_id,
            'user_id' => $user_id,
        ) );

    }

}

new AutomatorWP_Fluent_Support_Client_Get_Reply_Ticket();