<?php
/**
 * Agent Reply Ticket
 *
 * @package     AutomatorWP\Integrations\Fluent_Support\Triggers\Agent_Reply_Ticket
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Fluent_Support_Agent_Reply_Ticket extends AutomatorWP_Integration_Trigger {

    public $integration = 'fluent_support';
    public $trigger = 'fluent_support_agent_reply_ticket';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'Agent replies to a ticket', 'automatorwp-pro' ),
            'select_option'     => __( 'Agent <strong>replies</strong> to a ticket', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'Agent replies to a ticket %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'Agent replies to a ticket', 'automatorwp-pro' ),
            'action'            => 'fluent_support/response_added_by_agent',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 2,
            'options'           => array(
                'times' => automatorwp_utilities_times_option()
            ),
            'tags' => array_merge(
                automatorwp_utilities_post_tags( __( 'Ticket', 'automatorwp-pro' ) ),
                automatorwp_utilities_times_tag( )
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param array $response   Response data
     * @param array $ticket     Ticket data
     */
    public function listener( $ticket, $response ) {
        global $wpdb;

        $closed_by = absint( $ticket['closed_by'] );
        $customer_id = absint( $ticket['customer_id'] );
        $ticket_id = absint( $ticket['id'] );

        $agent = $wpdb->get_row( "SELECT * FROM {$wpdb->prefix}fs_persons WHERE id={$closed_by}");

        // Bail if agent not found
        if( ! $agent ) {
            return;
        }

        // Bail if ticket was closed by the customer
        if ( $customer_id === $closed_by ){
            return;
        }

        $user_id = absint( $agent->user_id );

        // If not user ID assigned, try to find the user by email
        if( $user_id === 0 ) {
            $user = get_user_by( 'email', $agent->email );

            // Bail if user not found
            if( ! $user ) {
                return;
            }

            $user_id = $user->ID;
        }

        automatorwp_trigger_event( array(
            'trigger' => $this->trigger,
            'post_id' => $ticket_id,
            'user_id' => $user_id,
        ) );

    }

}

new AutomatorWP_Fluent_Support_Agent_Reply_Ticket();