<?php
/**
 * Plugin Name:           AutomatorWP - Fluent Support
 * Plugin URI:            https://automatorwp.com/add-ons/fluent-support/
 * Description:           Connect AutomatorWP with Fluent Support.
 * Version:               1.0.2
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-fluent-support
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.7
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Fluent_Support
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Fluent_Support {

    /**
     * @var         AutomatorWP_Fluent_Support $instance The one true AutomatorWP_Fluent_Support
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Fluent_Support self::$instance The one true AutomatorWP_Fluent_Support
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Fluent_Support();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_FLUENT_SUPPORT_VER', '1.0.2' );

        // Plugin file
        define( 'AUTOMATORWP_FLUENT_SUPPORT_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_FLUENT_SUPPORT_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_FLUENT_SUPPORT_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_FLUENT_SUPPORT_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_FLUENT_SUPPORT_DIR . 'includes/ajax-functions.php';

            // Triggers
            require_once AUTOMATORWP_FLUENT_SUPPORT_DIR . 'includes/triggers/agent-open-ticket.php';
            require_once AUTOMATORWP_FLUENT_SUPPORT_DIR . 'includes/triggers/agent-reply-ticket.php';
            require_once AUTOMATORWP_FLUENT_SUPPORT_DIR . 'includes/triggers/agent-get-reply-ticket.php';
            require_once AUTOMATORWP_FLUENT_SUPPORT_DIR . 'includes/triggers/agent-close-ticket.php';
            require_once AUTOMATORWP_FLUENT_SUPPORT_DIR . 'includes/triggers/client-open-ticket.php';
            require_once AUTOMATORWP_FLUENT_SUPPORT_DIR . 'includes/triggers/client-reply-ticket.php';
            require_once AUTOMATORWP_FLUENT_SUPPORT_DIR . 'includes/triggers/client-get-reply-ticket.php';
            require_once AUTOMATORWP_FLUENT_SUPPORT_DIR . 'includes/triggers/client-close-ticket.php';

            // Actions
            require_once AUTOMATORWP_FLUENT_SUPPORT_DIR . 'includes/actions/create-ticket.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        
        
        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'fluent_support', array(
            'label' => 'Fluent Support',
            'icon'  => AUTOMATORWP_FLUENT_SUPPORT_URL . 'assets/fluent-support.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! defined( 'FLUENT_SUPPORT_VERSION' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Fluent_Support instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Fluent_Support The one true AutomatorWP_Fluent_Support
 */
function AutomatorWP_Fluent_Support() {
    return AutomatorWP_Fluent_Support::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Fluent_Support' );
