<?php
/**
 * Add affiliate
 *
 * @package     AutomatorWP\Integrations\Easy_Affiliate\Actions\Add_Affiliate
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Easy_Affiliate_Add_Affiliate extends AutomatorWP_Integration_Action {

    public $integration = 'easy_affiliate';
    public $action = 'easy_affiliate_add_affiliate';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Add user as affiliate', 'automatorwp-pro' ),
            'select_option'     => __( 'Add user as <strong>affiliate</strong>', 'automatorwp-pro' ),
            'edit_label'        => __( 'Add user as affiliate', 'automatorwp-pro' ),
            'log_label'         => __( 'Add user as affiliate', 'automatorwp-pro' ),
            'options'           => array(

            ),
        ) );

    }

    
    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        $this->result = '';

        // Bail if no user
        if( absint( $user_id === 0) ) {
            return;
        }
        $affiliate = new EasyAffiliate\Models\User();
        $user_affiliate = get_user_meta( $user_id, 'wafp_is_affiliate', true );

        // Bail if user is affiliated
        if ( isset ( $user_affiliate ) && $user_affiliate === '1' ) {
            $this->result = __( 'User is already an affiliate.', 'automatorwp-pro' );
            return;
        }

        update_user_meta( $user_id, 'wafp_is_affiliate', '1' );

        $this->result = __( 'User becomes an affiliate.', 'automatorwp-pro' );
        
    }

    /**
     * Register required hooks
     *
     * @since 1.0.0
     */
    public function hooks() {

        // Log meta data
        add_filter( 'automatorwp_user_completed_action_log_meta', array( $this, 'log_meta' ), 10, 5 );

        // Log fields
        add_filter( 'automatorwp_log_fields', array( $this, 'log_fields' ), 10, 5 );

        parent::hooks();

    }    

    /**
     * Action custom log meta
     *
     * @since 1.0.0
     *
     * @param array     $log_meta           Log meta data
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     *
     * @return array
     */
    public function log_meta( $log_meta, $action, $user_id, $action_options, $automation ) {

        // Bail if action type don't match this action
        if( $action->type !== $this->action ) {
            return $log_meta;
        }

        // Store the action's result
        $log_meta['result'] = $this->result;

        return $log_meta;
    }

    /**
     * Action custom log fields
     *
     * @since 1.0.0
     *
     * @param array     $log_fields The log fields
     * @param stdClass  $log        The log object
     * @param stdClass  $object     The trigger/action/automation object attached to the log
     *
     * @return array
     */
    public function log_fields( $log_fields, $log, $object ) {

        // Bail if log is not assigned to an action
        if( $log->type !== 'action' ) {
            return $log_fields;
        }

        // Bail if action type don't match this action
        if( $object->type !== $this->action ) {
            return $log_fields;
        }

        $log_fields['result'] = array(
            'name' => __( 'Result:', 'automatorwp-pro' ),
            'type' => 'text',
        );

        return $log_fields;
    }    

}

new AutomatorWP_Easy_Affiliate_Add_Affiliate();