<?php
/**
 * Tags
 *
 * @package     AutomatorWP\WP_Download_Manager\Tags
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Download tags
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_download_manager_download_tags() {

    return array(
        'download_id' => array(
            'label'     => __( 'Download ID', 'automatorwp-pro' ),
            'type'      => 'integer',
            'preview'   => '123',
        ),
        'download_title' => array(
            'label'     => __( 'Download title', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'Download title',
        ),
        'download_description' => array(
            'label'     => __( 'Download description', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'Download description',
        ),
        'download_excerpt' => array(
            'label'     => __( 'Download excerpt', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'Download excerpt',
        ),
    );

}

/**
 * Custom trigger tag replacement
 *
 * @since 1.0.0
 *
 * @param string    $replacement    The tag replacement
 * @param string    $tag_name       The tag name (without "{}")
 * @param stdClass  $trigger        The trigger object
 * @param int       $user_id        The user ID
 * @param string    $content        The content to parse
 * @param stdClass  $log            The last trigger log object
 *
 * @return string
 */
function automatorwp_download_manager_get_trigger_download_tag_replacement( $replacement, $tag_name, $trigger, $user_id, $content, $log ) {


    $trigger_args = automatorwp_get_trigger( $trigger->type );

    // Skip if trigger is not from this integration
    if( $trigger_args['integration'] !== 'wp_download_manager' ) {
        return $replacement;
    }

    switch( $tag_name ) {
        case 'download_id':
            $replacement = automatorwp_get_log_meta( $log->id, 'download_id', true );
            break;
        case 'download_title':
            $replacement = automatorwp_get_log_meta( $log->id, 'download_title', true );
            break;      
        case 'download_description':
            $replacement = automatorwp_get_log_meta( $log->id, 'download_description', true );
            break; 
        case 'download_excerpt':
            $replacement = automatorwp_get_log_meta( $log->id, 'download_excerpt', true );
            break;      
    }

    return $replacement;

}
add_filter( 'automatorwp_get_trigger_tag_replacement', 'automatorwp_download_manager_get_trigger_download_tag_replacement', 10, 6 );
