<?php
/**
 * Plugin Name:           AutomatorWP - Custom User Fields
 * Plugin URI:            https://automatorwp.com/add-ons/custom_user_fields/
 * Description:           Manage your own custom user fields through AutomatorWP
 * Version:               1.0.0
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-custom-user-fields
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.7
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Custom User Fields
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Custom_User_Fields {

    /**
     * @var         AutomatorWP_Custom_User_Fields $instance The one true AutomatorWP_Custom_User_Fields
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Custom_User_Fields self::$instance The one true AutomatorWP_Custom_User_Fields
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Custom_User_Fields();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->integrations();
            self::$instance->hooks();        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_CUSTOM_USER_FIELDS_VER', '1.0.0' );

        // Plugin file
        define( 'AUTOMATORWP_CUSTOM_USER_FIELDS_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_CUSTOM_USER_FIELDS_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_CUSTOM_USER_FIELDS_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_CUSTOM_USER_FIELDS_DIR . 'includes/custom-tables.php';
            require_once AUTOMATORWP_CUSTOM_USER_FIELDS_DIR . 'includes/custom-user-fields.php';
            require_once AUTOMATORWP_CUSTOM_USER_FIELDS_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_CUSTOM_USER_FIELDS_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_CUSTOM_USER_FIELDS_DIR . 'includes/scripts.php';
            require_once AUTOMATORWP_CUSTOM_USER_FIELDS_DIR . 'includes/tags.php';
            require_once AUTOMATORWP_CUSTOM_USER_FIELDS_DIR . 'includes/users.php';
            require_once AUTOMATORWP_CUSTOM_USER_FIELDS_DIR . 'includes/shortcodes.php';

            // Integrations
            require_once AUTOMATORWP_CUSTOM_USER_FIELDS_DIR . 'includes/integrations/automatorwp-restrict-content.php';

            // Triggers
            require_once AUTOMATORWP_CUSTOM_USER_FIELDS_DIR . 'includes/triggers/custom-user-field-update.php';

            // Anonymous Triggers

            // Actions
            require_once AUTOMATORWP_CUSTOM_USER_FIELDS_DIR . 'includes/actions/update-custom-user-field.php';

        }
    }

    /**
     * Register plugin integrations
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function integrations() {

        // Register the integration
        automatorwp_register_integration( 'custom_user_fields', array(
            'label' => 'Custom User Fields',
            'icon'  => AUTOMATORWP_CUSTOM_USER_FIELDS_URL . 'assets/img/custom-user-fields.svg',
        ) );

    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Custom_User_Fields instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Custom_User_Fields The one true AutomatorWP_Custom_User_Fields
 */
function AutomatorWP_Custom_User_Fields() {
    return AutomatorWP_Custom_User_Fields::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Custom_User_Fields' );
