<?php
/**
 * Scripts
 *
 * @package     AutomatorWP\Integrations\CSV\Scripts
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_csv_admin_register_scripts() {

    // Use minified libraries if SCRIPT_DEBUG is turned off
    $suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    // Scripts
    wp_register_script( 'automatorwp-csv-js', AUTOMATORWP_CSV_URL . 'assets/js/automatorwp-csv' . $suffix . '.js', array( 'jquery' ), AUTOMATORWP_CSV_VER, true );

}
add_action( 'admin_init', 'automatorwp_csv_admin_register_scripts' );

/**
 * Enqueue admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_csv_admin_enqueue_scripts( $hook ) {

    // Scripts
    wp_localize_script( 'automatorwp-csv-js', 'automatorwp_csv', array(
        'nonce' => automatorwp_get_admin_nonce(),
    ) );

    wp_enqueue_script( 'automatorwp-csv-js' );

}
add_action( 'admin_enqueue_scripts', 'automatorwp_csv_admin_enqueue_scripts', 100 );