<?php
/**
 * Functions
 *
 * @package     AutomatorWP\CSV\Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Get data sources
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_csv_data_sources() {

    return apply_filters( 'automatorwp_csv_data_sources', array(
        'upload'        => __( 'Upload file', 'automatorwp-pro' ),
        'paste'         => __( 'Paste data', 'automatorwp-pro' ),
    ) );

}

/**
 * CSV separators
 *
 * @since 1.0.0
 *
 * @return array
 */

function automatorwp_csv_separators() {

    $separator_characteres = array (
        'comma'     => ',',
        'semicolon' => ';',
        'pipe'      => '|',
        'tab'       => '\t',
    );

    return $separator_characteres;
}

/**
 * Get data from CSV file
 *
 * @since 1.0.0
 *
 * @param string    $url
 * @param bool      $exclude_header
 * @param string    $skip_rows
 * @param string    $limit_rows
 * @param string    $separator
 *
 * @return array
 */
function automatorwp_csv_get_data_from_csv_file ( $url, $exclude_header, $skip_rows, $limit_rows, $separator ){

    if( empty($url) )
        return array();

    $request = wp_remote_get( $url );

    if( ! is_array( $request ) && ! isset( $request['body'] ) ) {
        return array();
    }

    return automatorwp_csv_get_data_from_csv_data( $request['body'], $exclude_header, $skip_rows, $limit_rows, $separator );

}

/**
 * Get data from CSV text
 *
 * @since 1.0.0
 *
 * @param string    $csv_text
 * @param bool      $exclude_header
 * @param string    $skip_rows
 * @param string    $limit_rows
 * @param string    $separator
 *
 * @return array
 */

function automatorwp_csv_get_data_from_csv_data( $csv_text, $exclude_header, $skip_rows, $limit_rows, $separator ){

    $separator_characteres = automatorwp_csv_separators();
    $data = array();

    $rows = explode("\n", $csv_text);

    // Exclude headers if enabled
    if ( $exclude_header )
        $skip_rows += 1;

    // Skip starting rows
    if ( ! empty ( $skip_rows ) )
        $rows = array_slice( $rows, $skip_rows );
    
    $count = 0;

    foreach ( $rows as $row ) {

        // Limit the rows to get
        if ( $count >= $limit_rows && $limit_rows !== 0)
            break;

        $data[] = str_getcsv( $row, $separator_characteres[$separator] ); 
        $count++;
    }
    
    return $data;
    
    

}