<?php
/**
 * Import File
 *
 * @package     AutomatorWP\Integrations\WordPress\Automations\Import_File
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Import_File_Automation extends AutomatorWP_Automation_Loop {

    public $integration = 'csv';
    public $type = 'import-file';

    public function register() {

        // Automation type args
        $this->args = array(
            'image' => AUTOMATORWP_CSV_URL . 'assets/img/automatorwp-import-file-csv.svg',
            'label' => __( 'Import file', 'automatorwp-pro' ),
            'desc'  => __( 'Run actions according to the lines in a file.', 'automatorwp-pro' ),
            // Automation loop specific args
            'labels' => array(
                'singular' => __( 'Line', 'automatorwp-pro' ),
                'plural' => __( 'Lines', 'automatorwp-pro' ),
            ),
            'required_trigger' => 'csv_import_file',
        );
    }

    public function process_items( $items_ids, $automation, $trigger, $trigger_options ) {

        global $automatorwp_event;
        
        // Set up a false event since the following functions require it
        $automatorwp_event = array(
            'line_id' => 0,
            'user_id' => 0,
        );

        foreach ( $items_ids as $items_id ) {

            $line_id = absint( $items_id );
            $user_id = get_current_user_id();
            $automatorwp_event['line_id'] = $line_id;
            $automatorwp_event['user_id'] = $user_id;

            foreach( $trigger_options as $option => $value ) {
                // Replace all tags by their replacements
                $trigger_options[$option] = automatorwp_parse_automation_tags( $automation->id, $user_id, $value );
            }

            // Check if user deserves the trigger filters
            if( ! automatorwp_user_deserves_trigger_filters( $trigger, $user_id, $automatorwp_event, $trigger_options, $automation ) ) {
                continue;
            }

            // Execute all automation actions
            automatorwp_execute_all_automation_actions( $automation, $user_id, $automatorwp_event );

        }

    }

    public function get_items_count( $automation, $trigger ) {
    
        // In import file, items SQL returns the document data
        $count = $this->get_items_sql( $automation, $trigger, true );

        if( ! $count ) {
            return false;
        }

        return absint( $count );
    }

    public function get_items_ids( $automation, $trigger ) {
    
        // In import file, items SQL returns the document data
        $lines = $this->get_items_sql( $automation, $trigger, false );

        if( ! $lines ) {
            return false;
        }

        $key_lines = array_keys( $lines );

        return $key_lines;
    }

}

new AutomatorWP_Import_File_Automation();