<?php
/**
 * Calculate Filter
 *
 * @package     AutomatorWP\Integrations\Calculator\Filters\Calculate_Filter
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_WordPress_Calculate_Filter extends AutomatorWP_Integration_Filter {

    public $integration = 'calculator';
    public $filter = 'calculator_calculate_filter';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_filter( $this->filter, array(
            'integration'       => $this->integration,
            'label'             => __( 'Calculate', 'automatorwp' ),
            'select_option'     => __( 'Calculate', 'automatorwp' ),
            /* translators: %1$s: Formula. %2$s: Condition. %1$s: Formula. */
            'edit_label'        => sprintf( __( '%1$s %2$s %3$s', 'automatorwp' ), '{first_formula}', '{condition}', '{second_formula}'  ),
            /* translators: %1$s: Formula. %2$s: Condition. %1$s: Formula. */
            'log_label'         => sprintf( __( '%1$s %2$s %3$s', 'automatorwp' ), '{first_formula}', '{condition}', '{second_formula}' ),
            'options'           => array(
                'first_formula' => array(
                    'from' => 'first_formula',
                    'default' => __( 'formula 1', 'automatorwp' ),
                    'fields' => array(
                        'first_formula' => array(
                            'name' => __( 'Formula 1:', 'automatorwp' ),
                            'type' => 'text',
                            'default' => ''
                        ),
                    ),
                ),
                'condition' => automatorwp_utilities_condition_option(),
                'second_formula' => array(
                    'from' => 'second_formula',
                    'default' => __( 'formula 2', 'automatorwp' ),
                    'fields' => array(
                        'second_formula' => array(
                            'name' => __( 'Formula 2:', 'automatorwp' ),
                            'type' => 'text',
                            'default' => ''
                        ),
                    ),
                ),
            ),
        ) );

    }

    /**
     * User deserves check
     *
     * @since 1.0.0
     *
     * @param bool      $deserves_filter    True if user deserves filter, false otherwise
     * @param stdClass  $filter             The filter object
     * @param int       $user_id            The user ID
     * @param array     $event              Event information
     * @param array     $filter_options     The filter's stored options
     * @param stdClass  $automation         The trigger's automation object
     *
     * @return bool                          True if user deserves trigger, false otherwise
     */
    public function user_deserves_filter( $deserves_filter, $filter, $user_id, $event, $filter_options, $automation ) {

        require_once AUTOMATORWP_CALCULATOR_DIR . 'vendor/autoload.php';
        
        // Shorthand
        $first_formula = $filter_options['first_formula'];
        $condition = $filter_options['condition'];
        $second_formula = $filter_options['second_formula'];

        $first_formula_result = automatorwp_calculator_calculate_result( $first_formula ); 
        $second_formula_result = automatorwp_calculator_calculate_result( $second_formula );

        // Don't deserve if meta value doesn't match with the user meta value
        if( ! automatorwp_condition_matches( $first_formula_result, $second_formula_result, $condition ) ) {
            $this->result = sprintf( __( 'Filter not passed. "%1$s" does not meets the condition %2$s "%3$s".', 'automatorwp' ),
                $first_formula,
                automatorwp_utilities_get_condition_label( $condition ),
                $second_formula
            );
            return false;
        }

        $this->result = sprintf( __( 'Filter passed. "%1$s" %2$s "%3$s".', 'automatorwp' ),
            $first_formula,
            automatorwp_utilities_get_condition_label( $condition ),
            $second_formula
        );

        return $deserves_filter;

    }

}

new AutomatorWP_WordPress_Calculate_Filter();