<?php
/**
 * Send Friendship
 *
 * @package     AutomatorWP\Integrations\BuddyPress\Triggers\Send_Friendship
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_BuddyPress_Send_Friendship extends AutomatorWP_Integration_Trigger {

    public $integration = 'buddypress';
    public $trigger = 'buddypress_send_friendship';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User sends a friendship request', 'automatorwp-pro' ),
            'select_option'     => __( 'User <strong>sends a friendship</strong> request', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User sends a friendship request %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User sends a friendship request', 'automatorwp-pro' ),
            'action'            => 'friends_friendship_requested',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 3,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int $friendship_id
     * @param int $initiator_user_id
     * @param int $friend_user_id
     */
    public function listener( $friendship_id, $initiator_user_id, $friend_user_id ) {

        $user_id = $initiator_user_id;

        // Trigger the send friendship
        automatorwp_trigger_event( array(
            'trigger'       => $this->trigger,
            'user_id'       => $user_id,
        ) );

    }

}

new AutomatorWP_BuddyPress_Send_Friendship();