<?php
/**
 * Update User Profile Field
 *
 * @package     AutomatorWP\Integrations\BuddyPress\Actions\Update_User_Profile_Field
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_BuddyPress_Update_User_Profile_Field extends AutomatorWP_Integration_Action {

    public $integration = 'buddypress';
    public $action = 'buddypress_update_user_profile_field';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Update user profile field', 'automatorwp-pro' ),
            'select_option'     => __( 'Update user <strong>profile field</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Field name. %2$s: Field value. */
            'edit_label'        => sprintf( __( 'Update the user profile field %1$s with the value %2$s', 'automatorwp-pro' ), '{field_name}', '{field_value}' ),
            /* translators: %1$s: Field name. %2$s: Field value. */
            'log_label'         => sprintf( __( 'Update the user profile field %1$s with the value %2$s', 'automatorwp-pro' ), '{field_name}', '{field_value}' ),
            'options'           => array(
                'field_name' => automatorwp_utilities_ajax_selector_option( array(
                    'field'             => 'field_name',
                    'name'              => __( 'Field:', 'automatorwp-pro' ),
                    'option_none_value' => 'any',
                    'option_none_label' => __( 'field name', 'automatorwp-pro' ),
                    'option_custom'         => true,
                    'option_custom_desc'    => __( 'Field ID.', 'automatorwp-pro' )
                        . ' ' . __( 'The field ID can be found in the URL when editing a profile field, in the part of the URL that says "&field_id={FIELD_ID}", where {FIELD_ID} should be a number that corresponds to the field ID.', 'automatorwp-pro' ),
                    'action_cb'         => 'automatorwp_buddypress_get_profile_fields',
                    'options_cb'        => 'automatorwp_buddypress_options_cb_profile_field',
                    'default'           => 'any'
                ) ),
                'field_value' => array(
                    'from' => 'field_value',
                    'default' => __( 'field value', 'automatorwp-pro' ),
                    'fields' => array(
                        'field_value' => array(
                            'name' => __( 'Field value:', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        )
                    )
                ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        if( ! function_exists( 'xprofile_set_field_data' ) ) {
            return;
        }

        // Shorthand
        $field_name = $action_options['field_name'];
        $field_value = $action_options['field_value'];

        // Bail if field ID or name not provided
        if( empty( $field_name ) ) {
            return;
        }

        // Update the user profile field
        xprofile_set_field_data( $field_name, $user_id, $field_value, false );


    }

}

new AutomatorWP_BuddyPress_Update_User_Profile_Field();