<?php
/**
 * Send Friendship
 *
 * @package     AutomatorWP\Integrations\BuddyBoss\Triggers\Send_Friendship
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_BuddyBoss_Send_Friendship extends AutomatorWP_Integration_Trigger {

    public $integration = 'buddyboss';
    public $trigger = 'buddyboss_send_friendship';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User sends a friendship request', 'automatorwp-pro' ),
            'select_option'     => __( 'User <strong>sends a friendship</strong> request', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User sends a friendship request %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User sends a friendship request', 'automatorwp-pro' ),
            'action'            => 'friends_friendship_requested',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 3,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_times_tag(),
                automatorwp_buddyboss_get_friendship_tags()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int $friendship_id
     * @param int $initiator_user_id
     * @param int $friend_user_id
     */
    public function listener( $friendship_id, $initiator_user_id, $friend_user_id ) {

        $user_id = $initiator_user_id;

        // Trigger the send friendship
        automatorwp_trigger_event( array(
            'trigger'       => $this->trigger,
            'user_id'       => $user_id,
            'friend_id'     => $friend_user_id
        ) );

    }

    /**
     * Register the required hooks
     *
     * @since 1.0.0
     */
    public function hooks() {

        // Log meta data
        add_filter( 'automatorwp_user_completed_trigger_log_meta', array( $this, 'log_meta' ), 10, 6 );

        parent::hooks();
    }

    /**
     * Trigger custom log meta
     *
     * @since 1.0.0
     *
     * @param array     $log_meta           Log meta data
     * @param stdClass  $trigger            The trigger object
     * @param int       $user_id            The user ID
     * @param array     $event              Event information
     * @param array     $trigger_options    The trigger's stored options
     * @param stdClass  $automation         The trigger's automation object
     *
     * @return array
     */
    function log_meta( $log_meta, $trigger, $user_id, $event, $trigger_options, $automation ) {

        // Bail if action type don't match this action
        if( $trigger->type !== $this->trigger ) {
            return $log_meta;
        }

        $log_meta['friend_id'] = ( isset( $event['friend_id'] ) ? $event['friend_id'] : '' );
        
        return $log_meta;

    }

}

new AutomatorWP_BuddyBoss_Send_Friendship();