<?php
/**
 * Get Favorite Activity
 *
 * @package     AutomatorWP\Integrations\BuddyBoss\Triggers\Get_Favorite_Activity
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_BuddyBoss_Get_Favorite_Activity extends AutomatorWP_Integration_Trigger {

    public $integration = 'buddyboss';
    public $trigger = 'buddyboss_get_favorite_activity';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User gets a like on an activity stream message', 'automatorwp-pro' ),
            'select_option'     => __( 'User <strong>gets a like</strong> on an activity stream message', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User gets a like on an activity stream message %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User gets a like on an activity stream message', 'automatorwp-pro' ),
            'action'            => 'bp_activity_add_user_favorite',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 2,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_buddyboss_get_activity_tags(),
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int $activity_id
     * @param int $user_id
     */
    public function listener( $activity_id, $user_id ) {

        $activity = new BP_Activity_Activity( $activity_id );

        // Trigger the get favorite on an activity
        automatorwp_trigger_event( array(
            'trigger'               => $this->trigger,
            'user_id'               => $activity->user_id,
            'activity_id'           => $activity->id,
            'activity_content'      => $activity->content,
            'activity_author_id'    => $activity->user_id,
        ) );

    }

    /**
     * Trigger custom log meta
     *
     * @since 1.0.0
     *
     * @param array     $log_meta           Log meta data
     * @param stdClass  $trigger            The trigger object
     * @param int       $user_id            The user ID
     * @param array     $event              Event information
     * @param array     $trigger_options    The trigger's stored options
     * @param stdClass  $automation         The trigger's automation object
     *
     * @return array
     */
    function log_meta( $log_meta, $trigger, $user_id, $event, $trigger_options, $automation ) {

        // Bail if action type don't match this action
        if( $trigger->type !== $this->trigger ) {
            return $log_meta;
        }

        $log_meta['activity_id'] = ( isset( $event['activity_id'] ) ? $event['activity_id'] : '' );
        $log_meta['activity_content'] = ( isset( $event['activity_content'] ) ? $event['activity_content'] : '' );
        $log_meta['activity_author_id'] = ( isset( $event['activity_author_id'] ) ? $event['activity_author_id'] : '' );
        $log_meta['activity_media_urls'] = automatorwp_buddyboss_get_activity_media_urls( $event['activity_id'] );
        $log_meta['activity_video_urls'] = automatorwp_buddyboss_get_activity_video_urls( $event['activity_id'] );
        $log_meta['activity_document_urls'] = automatorwp_buddyboss_get_activity_document_urls( $event['activity_id'] );

        return $log_meta;

    }

    /**
     * Action custom log fields
     *
     * @since 1.0.0
     *
     * @param array     $log_fields The log fields
     * @param stdClass  $log        The log object
     * @param stdClass  $object     The trigger/action/automation object attached to the log
     *
     * @return array
     */
    public function log_fields( $log_fields, $log, $object ) {

        // Bail if log is not assigned to an trigger
        if( $log->type !== 'trigger' ) {
            return $log_fields;
        }

        // Bail if trigger type don't match this trigger
        if( $object->type !== $this->trigger ) {
            return $log_fields;
        }

        $log_fields['activity_content'] = array(
            'name' => __( 'Activity Content', 'automatorwp-pro' ),
            'desc' => __( 'The activity content.', 'automatorwp-pro' ),
            'type' => 'text',
        );

        return $log_fields;

    }

}

new AutomatorWP_BuddyBoss_Get_Favorite_Activity();