<?php
/**
 * Filters
 *
 * @package     AutomatorWP\Block_Users\Filters
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Check if user has access check.
 *
 * @since 1.0.0
 *
 * @param bool      $has_access         True if user has access, false otherwise
 * @param stdClass  $trigger            The trigger object
 * @param int       $user_id            The user ID
 * @param array     $event              Event information
 * @param array     $trigger_options    The trigger's stored options
 * @param stdClass  $automation         The trigger's automation object
 *
 * @return bool                         True if user has access, false otherwise
 */
function automatorwp_block_users_user_has_access_to_trigger( $has_access, $trigger, $user_id, $event, $trigger_options, $automation ) {

    // Bail if user hasn't access
    if( ! $has_access ) {
        return $has_access;
    }

    ct_setup_table( 'automatorwp_automations' );

    $blocked_roles = ct_get_object_meta( $automation->id, 'blocked_roles', true );

    // Check if user role has been blocked
    if( is_array( $blocked_roles ) ) {

        foreach( $blocked_roles as $blocked_role ) {
            if( user_can( $user_id, $blocked_role ) ) {
                return false;
            }
        }

    }

    $blocked_users = ct_get_object_meta( $automation->id, 'blocked_users', true );

    // Check if user has been blocked
    if( is_array( $blocked_users ) ) {

        // Turn blocked users IDs to integer to ensure same types in next check
        $blocked_users = array_map( 'intval', $blocked_users );

        if( in_array( $user_id, $blocked_users ) ) {
            return false;
        }
    }

    ct_reset_setup_table();

    return $has_access;

}
add_filter( 'automatorwp_user_has_access_to_trigger', 'automatorwp_block_users_user_has_access_to_trigger', 10, 6 );