<?php
/**
 * Admin
 *
 * @package     AutomatorWP\Block_Users\Admin
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register custom CMB2 meta boxes
 *
 * @since  1.0.0
 */
function automatorwp_block_users_automations_meta_boxes( ) {

    // Block Users
    automatorwp_add_meta_box(
        'automatorwp-pro',
        __( 'Block users', 'automatorwp-pro' ),
        'automatorwp_automations',
        array(
            'blocked_roles' => array(
                'name' 	=> __( 'Blocked roles', 'automatorwp-pro' ),
                'desc' 	=> __( 'Block users by role to being able to complete this automation.', 'automatorwp-pro' ),
                'type' 	=> 'automatorwp_select',
                'attributes' => array(
                    'multiple' => true
                ),
                'option_none' => false,
                'classes' => 'automatorwp-selector automatorwp-has-tooltip',
                'options_cb' => 'automatorwp_options_cb_roles',
                'after_field' => 'automatorwp_tooltip_cb',
            ),
            'blocked_users' => array(
                'name' 	=> __( 'Blocked users', 'automatorwp-pro' ),
                'desc' 	=> __( 'Block specific users to being able to complete this automation.', 'automatorwp-pro' ),
                'type' 	=> 'automatorwp_select',
                'attributes' => array(
                    'multiple' => true
                ),
                'classes' => 'automatorwp-user-selector automatorwp-has-tooltip',
                'options_cb' => 'automatorwp_options_cb_users',
                'after_field' => 'automatorwp_tooltip_cb',
            ),
        ),
        array(
            'priority' => 'default',
            'context' => 'side',
        )
    );

}
add_action( 'cmb2_admin_init', 'automatorwp_block_users_automations_meta_boxes' );