<?php
/**
 * Plugin Name:           AutomatorWP - Autonami
 * Plugin URI:            https://automatorwp.com/add-ons/autonami/
 * Description:           Connect AutomatorWP with Autonami.
 * Version:               1.0.2
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-autonami
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.3
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Autonami
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Autonami {

    /**
     * @var         AutomatorWP_Autonami $instance The one true AutomatorWP_Autonami
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Autonami self::$instance The one true AutomatorWP_Autonami
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Autonami();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_AUTONAMI_VER', '1.0.2' );

        // Plugin file
        define( 'AUTOMATORWP_AUTONAMI_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_AUTONAMI_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_AUTONAMI_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_AUTONAMI_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_AUTONAMI_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_AUTONAMI_DIR . 'includes/tags.php';

            // Triggers
            require_once AUTOMATORWP_AUTONAMI_DIR . 'includes/triggers/user-tag-added.php';
            require_once AUTOMATORWP_AUTONAMI_DIR . 'includes/triggers/user-tag-removed.php';
            require_once AUTOMATORWP_AUTONAMI_DIR . 'includes/triggers/user-added-list.php';
            require_once AUTOMATORWP_AUTONAMI_DIR . 'includes/triggers/user-removed-list.php';
            require_once AUTOMATORWP_AUTONAMI_DIR . 'includes/triggers/user-set-status.php';

            // Anonymous Triggers
            require_once AUTOMATORWP_AUTONAMI_DIR . 'includes/triggers/anonymous-contact-added-list.php';
            require_once AUTOMATORWP_AUTONAMI_DIR . 'includes/triggers/anonymous-contact-removed-list.php';
            require_once AUTOMATORWP_AUTONAMI_DIR . 'includes/triggers/anonymous-contact-tag-added.php';
            require_once AUTOMATORWP_AUTONAMI_DIR . 'includes/triggers/anonymous-contact-tag-removed.php';

            // Actions
            require_once AUTOMATORWP_AUTONAMI_DIR . 'includes/actions/create-user-contact.php';
            require_once AUTOMATORWP_AUTONAMI_DIR . 'includes/actions/create-contact.php';
            require_once AUTOMATORWP_AUTONAMI_DIR . 'includes/actions/add-user-tag.php';
            require_once AUTOMATORWP_AUTONAMI_DIR . 'includes/actions/remove-user-tag.php';
            require_once AUTOMATORWP_AUTONAMI_DIR . 'includes/actions/add-user-list.php';
            require_once AUTOMATORWP_AUTONAMI_DIR . 'includes/actions/remove-user-list.php';
            require_once AUTOMATORWP_AUTONAMI_DIR . 'includes/actions/add-contact-tag.php';
            require_once AUTOMATORWP_AUTONAMI_DIR . 'includes/actions/remove-contact-tag.php';
            require_once AUTOMATORWP_AUTONAMI_DIR . 'includes/actions/add-contact-list.php';
            require_once AUTOMATORWP_AUTONAMI_DIR . 'includes/actions/remove-contact-list.php';
            
        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'autonami', array(
            'label' => 'Autonami',
            'icon'  => AUTOMATORWP_AUTONAMI_URL . 'assets/autonami.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! class_exists( 'BWFAN_Core' ) ) {
            return false;
        }

        if ( ! class_exists( 'BWFAN_Pro' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Autonami instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Autonami The one true AutomatorWP_Autonami
 */
function AutomatorWP_Autonami() {
    return AutomatorWP_Autonami::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Autonami' );
