<?php
/**
 * Get Vote Up
 *
 * @package     AutomatorWP\Integrations\AnsPress\Triggers\Get_Vote_Up
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_AnsPress_Get_Vote_Up extends AutomatorWP_Integration_Trigger {

    public $integration = 'anspress';
    public $trigger = 'anspress_get_vote_up';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User gets a vote up on an answer', 'automatorwp-pro' ),
            'select_option'     => __( 'User <strong>gets a vote up</strong> on an answer', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User gets a vote up on an answer %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User gets a vote up on an answer', 'automatorwp-pro' ),
            'action'            => 'ap_vote_up',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 1,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_post_tags( __( 'Answer', 'automatorwp-pro' ) ),
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int $post_id
     */
    public function listener( $post_id ) {

        $post = get_post( $post_id );
        $user_id = absint( $post->post_author );
        $voter_id = get_current_user_id();

        // Bail if user vote himself
        if( $user_id === $voter_id ) {
            return;
        }

        automatorwp_trigger_event( array(
            'trigger' => $this->trigger,
            'user_id' => $user_id,
            'post_id' => $post_id,
        ) );

    }

}

new AutomatorWP_AnsPress_Get_Vote_Up();