<?php
/**
 * Ajax Functions
 *
 * @package     AutomatorWP\Amelia\includes\Ajax_Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Ajax function for selecting services
 *
 * @since 1.0.0
 */
function automatorwp_ameliabooking_ajax_get_services() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );
    
    global $wpdb;

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? $wpdb->esc_like( $_REQUEST['q'] ) : '';

    $services = automatorwp_ameliabooking_get_services( );

    $results = array();

    // Parse service results to match select2 results
    foreach ( $services as $service ) {

        if( ! empty( $search ) ) {
            if( strpos( strtolower( $service['name'] ), strtolower( $search ) ) === false ) {
                continue;
            }
        }
        
        $results[] = array(
            'id' => $service['id'],
            'text' => $service['name']
        );
    }

    // Prepend option none
    $results = automatorwp_ajax_parse_extra_options( $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_ameliabooking_get_services', 'automatorwp_ameliabooking_ajax_get_services' );

/**
 * Ajax function for selecting events
 *
 * @since 1.0.0
 */
function automatorwp_ameliabooking_ajax_get_events() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );
    
    global $wpdb;

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? $wpdb->esc_like( $_REQUEST['q'] ) : '';

    $events = automatorwp_ameliabooking_get_events( );

    $results = array();

    // Parse service results to match select2 results
    foreach ( $events as $event ) {

        if( ! empty( $search ) ) {
            if( strpos( strtolower( $event['name'] ), strtolower( $search ) ) === false ) {
                continue;
            }
        }
        
        $results[] = array(
            'id'    => $event['id'],
            'text'  => $event['name']
        );
    }

    // Prepend option none
    $results = automatorwp_ajax_parse_extra_options( $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_ameliabooking_get_events', 'automatorwp_ameliabooking_ajax_get_events' );

