<?php
/**
 * User Field
 *
 * @package     AutomatorWP\Integrations\ActiveMember360\Actions\User_Field
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_ActiveMember360_User_Field extends AutomatorWP_Integration_Action {

    public $integration = 'activemember360';
    public $action = 'activemember360_user_field';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Set user contact field value', 'automatorwp-pro' ),
            'select_option'     => __( 'Set user contact <strong>field value</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Value. %2$s: Field. */
            'edit_label'        => sprintf( __( 'Set value %1$s for user contact field %2$s', 'automatorwp-pro' ), '{value}', '{field}' ),
            /* translators: %1$s: Value. %2$s: Field. */
            'log_label'         => sprintf( __( 'Set value %1$s for user contact field %2$s', 'automatorwp-pro' ), '{value}', '{field}' ),
            'options'           => array(
                'value' => array(
                    'from' => 'value',
                    'default' => __( 'value', 'automatorwp-pro' ),
                    'fields' => array(
                        'value' => array(
                            'name' => __( 'Value:', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        )
                    )
                ),
                'field' => array(
                    'from' => 'field',
                    'default' => __( 'field', 'automatorwp-pro' ),
                    'fields' => array(
                        'field' => array(
                            'name' => __( 'Field:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'classes' => 'automatorwp-selector',
                            'options_cb' => array( $this, 'fields_options_cb' ),
                            'default' => ''
                        )
                    )
                ),
            ),
        ) );

    }

    /**
     * Get lists options
     *
     * @since 1.0.0
     *
     * @return array
     */
    public function fields_options_cb() {

        $options = array(
            'first_name' => __( 'First Name', 'automatorwp-pro' ),
            'last_name' => __( 'Last Name', 'automatorwp-pro' ),
            'email' => __( 'Email', 'automatorwp-pro' ),
            'phone' => __( 'Phone', 'automatorwp-pro' ),
            'account_name' => __( 'Account Name', 'automatorwp-pro' ),
        );

        return $options;

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $field = $action_options['field'];
        $value = $action_options['value'];

        $user = get_user_by('id', $user_id);
        $user_email = $user->user_email;

        // Check if user is a contact in ActiveCampaign
        $user_am360 = mbr_get_contact_by_email( $user_email );

        if ( empty( $user_am360 ) )  {
            return;
        }

        // Update user field
        apply_filters( 'mbr/save_contact_fields', array( 'id' => $user_am360['id'], $field => $value ) );

    }

}

new AutomatorWP_ActiveMember360_User_Field();