<?php
/**
 * Plugin Name:           AutomatorWP - Thrive Apprentice integration
 * Plugin URI:            https://automatorwp.com/add-ons/thrive-apprentice/
 * Description:           Connect AutomatorWP with Thrive Apprentice.
 * Version:               1.0.0
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-thrive-apprentice-integration
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          5.9
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Thrive_Apprentice
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Integration_Thrive_Apprentice {

    /**
     * @var         AutomatorWP_Integration_Thrive_Apprentice $instance The one true AutomatorWP_Integration_Thrive_Apprentice
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Integration_Thrive_Apprentice self::$instance The one true AutomatorWP_Integration_Thrive_Apprentice
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Integration_Thrive_Apprentice();
            
            if( ! self::$instance->pro_installed() ) {

                self::$instance->constants();
                self::$instance->includes();
                
            }

            self::$instance->hooks();
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_THRIVE_APPRENTICE_VER', '1.0.0' );

        // Plugin file
        define( 'AUTOMATORWP_THRIVE_APPRENTICE_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_THRIVE_APPRENTICE_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_THRIVE_APPRENTICE_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_THRIVE_APPRENTICE_DIR . 'includes/tags.php';

            // Triggers
            require_once AUTOMATORWP_THRIVE_APPRENTICE_DIR . 'includes/triggers/complete-course.php';

            // Actions
            require_once AUTOMATORWP_THRIVE_APPRENTICE_DIR . 'includes/actions/user-product.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'thrive_apprentice', array(
            'label' => 'Thrive Apprentice',
            'icon'  => plugin_dir_url( __FILE__ ) . 'assets/thrive-apprentice.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! class_exists( 'TVA_Const' ) ) {
            return false;
        }

        return true;

    }

    /**
     * Check if the pro version of this integration is installed
     *
     * @since  1.0.0
     *
     * @return bool True if pro version installed
     */
    private function pro_installed() {

        if ( ! class_exists( 'AutomatorWP_Thrive_Apprentice' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Integration_Thrive_Apprentice instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Integration_Thrive_Apprentice The one true AutomatorWP_Integration_Thrive_Apprentice
 */
function AutomatorWP_Integration_Thrive_Apprentice() {
    return AutomatorWP_Integration_Thrive_Apprentice::instance();
}
add_action( 'automatorwp_pre_init', 'AutomatorWP_Integration_Thrive_Apprentice' );
