<?php
/**
 * Receive Message
 *
 * @package     AutomatorWP\Integrations\WPAdverts\Triggers\Receive_Message
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_WPAdverts_Receive_Message extends AutomatorWP_Integration_Trigger {

    public $integration = 'wpadverts';
    public $trigger = 'wpadverts_receive_message';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User receives a message from an advert', 'automatorwp-pro' ),
            'select_option'     => __( 'User <strong>receives a message</strong> from an advert', 'automatorwp-pro' ),
            /* translators: %1$s: Post Title. %2$s: Number of times. */
            'edit_label'        => sprintf( __( 'User receives a message from %1$s %2$s time(s)', 'automatorwp-pro' ), '{post}', '{times}' ),
            /* translators: %1$s: Post Title. */
            'log_label'         => sprintf( __( 'User receives a message from %1$s', 'automatorwp-pro' ), '{post}' ),
            'action'            => 'adext_contact_form_send',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 2,
            'options'           => array(
                'post' => automatorwp_utilities_post_option( array(
                    'name' => __( 'Advert:', 'automatorwp' ),
                    'option_none_label' => __( 'any advert', 'automatorwp' ),
                    'post_type' => 'advert'
                ) ),
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_post_tags( __( 'Advert', 'automatorwp-pro' ) ),
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int           $post_id
     * @param Adverts_Form  $form
     */
    public function listener( $post_id, $form ) {

        $post = get_post( $post_id );

        // Bail if post not exists
        if( ! $post ) {
            return;
        }

        // Bail if not is an advert
        if( $post->post_type !== 'advert' ) {
            return;
        }

        $user_id = $post->post_author;

        // Bail if can't find the user ID
        if( $user_id === 0 ) {
            return;
        }

        automatorwp_trigger_event( array(
            'trigger' => $this->trigger,
            'user_id' => $user_id,
            'post_id' => $post->ID,
        ) );

    }

    /**
     * User deserves check
     *
     * @since 1.0.0
     *
     * @param bool      $deserves_trigger   True if user deserves trigger, false otherwise
     * @param stdClass  $trigger            The trigger object
     * @param int       $user_id            The user ID
     * @param array     $event              Event information
     * @param array     $trigger_options    The trigger's stored options
     * @param stdClass  $automation         The trigger's automation object
     *
     * @return bool                          True if user deserves trigger, false otherwise
     */
    public function user_deserves_trigger( $deserves_trigger, $trigger, $user_id, $event, $trigger_options, $automation ) {

        // Don't deserve if post is not received
        if( ! isset( $event['post_id'] ) ) {
            return false;
        }

        // Don't deserve if post doesn't match with the trigger option
        if( ! automatorwp_posts_matches( $event['post_id'], $trigger_options['post'] ) ) {
            return false;
        }

        return $deserves_trigger;

    }

}

new AutomatorWP_WPAdverts_Receive_Message();