<?php
/**
 * Renew Subscription
 *
 * @package     AutomatorWP\Integrations\WP_Simple_Pay\Triggers\Renew_Subscription
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_WP_Simple_Pay_Renew_Subscription extends AutomatorWP_Integration_Trigger {

    public $integration = 'wp_simple_pay';
    public $trigger = 'wp_simple_pay_renew_subscription';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User renews a subscription', 'automatorwp-pro' ),
            'select_option'     => __( 'User <strong>renews</strong> a subscription', 'automatorwp-pro' ),
            /* translators: %1$s: Post title. %2$s: Number of times. */
            'edit_label'        => sprintf( __( 'User renews a subscription %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User renews a subscription', 'automatorwp-pro' ),
            'action'            => 'simpay_webhook_invoice_payment_succeeded',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 3,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_post_tags( __( 'Payment Form', 'automatorwp-pro' ) ),
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param \Stripe\Event        $event Stripe Event object.
     * @param \Stripe\Invoice      $invoice Stripe Invoice object.
     * @param \Stripe\Subscription $subscription Stripe Subscription object.
     */
    public function listener( $event, $invoice, $subscription ) {

        $user = get_user_by( 'email', $invoice->customer_email );

        // Bail if user can't be found
        if( ! $user ) {
            return;
        }

        $user_id = $user->ID;

        $payment = $event->data->object;

        if ( isset( $payment->metadata->simpay_form_id ) ) {
            $post_id = $payment->metadata->simpay_form_id;
        } else {
            $post_id = end( $payment->lines->data )->metadata->simpay_form_id;
        }

        // Trigger the complete purchase
        automatorwp_trigger_event( array(
            'trigger'   => $this->trigger,
            'user_id'   => $user_id,
            'post_id'   => $post_id,
        ) );

    }

}

new AutomatorWP_WP_Simple_Pay_Renew_Subscription();