<?php
/**
 * Tags
 *
 * @package     AutomatorWP\WhatsApp\Tags
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;


/**
 * Tags
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_whatsapp_get_webhook_tags() {

    return array(
        'from' => array(
            'label'     => __( 'From number:', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'Message received from the number',
        ),
        'received_time' => array(
            'label'     => __( 'Received time', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'The received time',
        ),
        'message' => array(
            'label'     => __( 'Message', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'The WhatsApp message',
        ),
        'profile' => array(
            'label'     => __( 'Profile name', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'The name of the sender',
        ),

    );

}

/**
 * Custom trigger tag replacement
 *
 * @since 1.0.0
 *
 * @param string    $replacement    The tag replacement
 * @param string    $tag_name       The tag name (without "{}")
 * @param stdClass  $trigger        The trigger object
 * @param int       $user_id        The user ID
 * @param string    $content        The content to parse
 * @param stdClass  $log            The last trigger log object
 *
 * @return string
 */
function automatorwp_whatsapp_get_trigger_tag_replacement( $replacement, $tag_name, $trigger, $user_id, $content, $log ) {


    $trigger_args = automatorwp_get_trigger( $trigger->type );

    // Skip if trigger is not from this integration
    if( $trigger_args['integration'] !== 'whatsapp' ) {
        return $replacement;
    }

    $replacement = automatorwp_get_log_meta( $log->id, $tag_name, true );

    return $replacement;

}
add_filter( 'automatorwp_get_trigger_tag_replacement', 'automatorwp_whatsapp_get_trigger_tag_replacement', 10, 6 );
