<?php
/**
 * Admin
 *
 * @package     AutomatorWP\Integrations\WhatsApp\Admin
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Shortcut function to get plugin options
 *
 * @since  1.0.0
 *
 * @param string    $option_name
 * @param bool      $default
 *
 * @return mixed
 */
function automatorwp_whatsapp_get_option( $option_name, $default = false ) {

    $prefix = 'automatorwp_whatsapp_';

    return automatorwp_get_option( $prefix . $option_name, $default );
}

/**
 * Register plugin settings sections
 *
 * @since  1.0.0
 *
 * @return array
 */
function automatorwp_whatsapp_settings_sections( $automatorwp_settings_sections ) {

    $automatorwp_settings_sections['whatsapp'] = array(
        'title' => __( 'WhatsApp', 'automatorwp-pro' ),
        'icon' => 'dashicons-whatsapp',
    );

    return $automatorwp_settings_sections;

}
add_filter( 'automatorwp_settings_sections', 'automatorwp_whatsapp_settings_sections' );

/**
 * Register plugin settings meta boxes
 *
 * @since  1.0.0
 *
 * @return array
 */
function automatorwp_whatsapp_settings_meta_boxes( $meta_boxes )  {

    $prefix = 'automatorwp_whatsapp_';

    $meta_boxes['automatorwp-whatsapp-settings'] = array(
        'title' => automatorwp_dashicon( 'whatsapp' ) . __( 'WhatsApp', 'automatorwp-pro' ),
        'fields' => apply_filters( 'automatorwp_whatsapp_settings_fields', array(
            $prefix . 'token' => array(
                'name' => __( 'API token:', 'automatorwp-pro' ),
                'desc' => sprintf( __( 'Your WhatsApp API token.'), 'automatorwp-pro' ),
                'type' => 'text',
            ),
            $prefix . 'business_id' => array(
                'name' => __( 'Business ID:', 'automatorwp-pro' ),
                'desc' => sprintf( __( 'Your WhatsApp Business ID.'), 'automatorwp-pro' ),
                'type' => 'text',
            ),
            $prefix . 'phone_id' => array(
                'name' => __( 'Phone ID:', 'automatorwp-pro' ),
                'desc' => sprintf( __( 'Your WhatsApp Business Phone ID.'), 'automatorwp-pro' ),
                'type' => 'text',
            ),
            $prefix . 'webhook' => array(
                'type' => 'text',
                'render_row_cb' => 'automatorwp_whatsapp_webhook_url_cb',
            ),
            $prefix . 'webhook_verification_id' => array(
                'name' => __( 'Webhook Verification ID:', 'automatorwp-pro' ),
                'desc' => sprintf( __( 'The webhook verification ID. Write your own verification code to use in the application created in Meta.'), 'automatorwp-pro' ),
                'type' => 'text',
            ),
            $prefix . 'authorize' => array(
                'type' => 'text',
                'render_row_cb' => 'automatorwp_whatsapp_authorize_display_cb'
            ),
        ) ),
    );

    return $meta_boxes;

}
add_filter( "automatorwp_settings_whatsapp_meta_boxes", 'automatorwp_whatsapp_settings_meta_boxes' );

/**
 * Display callback for the webhook URL
 *
 * @since  1.0.0
 *
 */

 function automatorwp_whatsapp_webhook_url_cb( ) {

    $webhook_url = automatorwp_whatsapp_get_webhook_url();

    ?>
    <div class="cmb-row cmb-type-custom cmb2-id-automatorwp-redirect-url table-layout" data-fieldtype="custom">
        <div class="cmb-th">
            <label><?php echo __( 'Webhook URL:', 'automatorwp' ); ?></label>
        </div>
        <div class="cmb-td">
            <input type="text" class="regular-text" value="<?php echo $webhook_url; ?>" readonly>
            <a id="automatorwp_whatsapp_refresh" class="button" href="#"><?php echo __( 'Regenerate URL', 'automatorwp' ); ?></a>
            <p class="cmb2-metabox-description"><?php echo __( 'Copy this URL and place it on your WhatsApp Business account.', 'automatorwp' ); ?></p>
        </div>
    </div>
    <?php

}

/**
 * Display callback for the authorize setting
 *
 * @since  1.0.0
 *
 * @param array      $field_args Array of field arguments.
 * @param CMB2_Field $field      The field object
 */
function automatorwp_whatsapp_authorize_display_cb( $field_args, $field ) {

    $field_id = $field_args['id'];
    
    $token = automatorwp_whatsapp_get_option( 'token', '' );
    $phone_id = automatorwp_whatsapp_get_option( 'phone_id', '' );
    $business_id = automatorwp_whatsapp_get_option( 'business_id', '' );
    $webhook_verification_id = automatorwp_whatsapp_get_option( 'webhook_verification_id', '' );

    ?>
    <div class="cmb-row cmb-type-custom cmb2-id-automatorwp-whatsapp-authorize table-layout" data-fieldtype="custom">
        <div class="cmb-th">
            <label><?php echo __( 'Connect with WhatsApp:', 'automatorwp-pro' ); ?></label>
        </div>
        <div class="cmb-td">
            <a id="<?php echo $field_id; ?>" class="button button-primary" href="#"><?php echo __( 'Save credentials', 'automatorwp-pro' ); ?></a>
            <p class="cmb2-metabox-description"><?php echo __( 'Add your WhatsApp API Token, Business ID, Phone ID, Webhook verification ID and click on "Authorize" to connect.', 'automatorwp-pro' ); ?></p>
            <?php if ( ! empty( $token )  && ! empty( $phone_id ) && ! empty( $business_id ) && ! empty( $webhook_verification_id ) ) : ?>
                <div class="automatorwp-notice-success"><?php echo __( 'Site connected with WhatsApp successfully.', 'automatorwp-pro' ); ?></div>
            <?php endif; ?>
        </div>    
    </div>
    <?php
}