<?php
/**
 * Integrations
 *
 * @package     AutomatorWP\Webhooks\Integrations
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Get a list of registered integrations
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_webhooks_get_integrations() {
    return array(
        'automatorwp' => 'webhook',
        'webhooks' => 'webhook',
        'airtable' => 'Airtable',
        'konnectzit' => 'KonnectzIT',
        'ifttt' => 'IFTTT',
        'integrately' => 'Integrately',
        'integromat' => 'Integromat',
        'make' => 'Make',
        'notion' => 'Notion',
        'zapier' => 'Zapier',
    );
}

/**
 * Get a list of registered integrations slugs
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_webhooks_get_integrations_slugs() {

    $integrations = automatorwp_webhooks_get_integrations();

    return array_keys( $integrations );

}

/**
 * Get a list of integrations trigger types
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_webhooks_get_integrations_trigger_types() {

    $integrations = automatorwp_webhooks_get_integrations();
    $slugs = array();

    foreach( $integrations as $integration => $label ) {
        $slugs[] = $integration . '_receive_webhook';
        $slugs[] = $integration . '_anonymous_receive_webhook';
    }

    return $slugs;

}