(function ( $ ) {

    var current_form;

    // Get samples
    $('body').on('click', '.automatorwp-webhooks-get-samples', function(e) {

        var button = $(this);

        if( button.prop('disabled') ) {
            return;
        }

        var response_wrap = button.prev('.automatorwp-webhook-get-samples-response');

        // Show spinner + waiting for samples response
        response_wrap.html('<div class="automatorwp-notice-warning"><span class="spinner is-active" style="margin: 0px 10px 2px 5px;"></span>' + automatorwp_webhooks_admin.get_samples + '</div>');

        // Disable button
        button.prop('disabled', true);

        var start_date = new Date();

        button.data('start', start_date.getTime() );

        automatorwp_webhooks_get_samples( button );

    });

    /**
     * Function to retrieve samples from server
     *
     * @since 1.0.0
     *
     * @param {Object} button
     */
    function automatorwp_webhooks_get_samples( button ) {

        var trigger_id = button.closest('.automatorwp-automation-item').find('input.id').val();
        var response_wrap = button.prev('.automatorwp-webhook-get-samples-response');

        $.ajax({
            url: ajaxurl,
            method: 'POST',
            data: {
                action: 'automatorwp_webhooks_get_samples',
                nonce: automatorwp_webhooks_admin.nonce,
                trigger_id: trigger_id
            },
            success: function( response ) {

                if( response.success ) {
                    // On success, check the samples found

                    if( response.data.samples.length ) {
                        // Samples found

                        // Empty dialog options
                        $('.automatorwp-webhooks-samples-dialog .automatorwp-webhooks-samples-options').html('');

                        var letters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';

                        // Update samples dialog options
                        Object.keys(response.data.samples).forEach(function( i ) {

                            var sample = response.data.samples[i];

                            // Setup the sample data HTML
                            var sample_data_html = '<div class="automatorwp-webhooks-sample-data-field">No data received</div>';

                            if( Object.keys(sample.data).length ) {

                                sample_data_html = '';

                                Object.keys(sample.data).forEach(function( key ) {

                                    var value = sample.data[key];

                                    sample_data_html += '<div class="automatorwp-webhooks-sample-data-field" data-field="' + key + '" data-value="' + value + '">'
                                        + '<strong>' + key + ':</strong> <span>' + value + '</span>'
                                        + '</div>';
                                });
                            }

                            // Setup the sample HTML
                            $('.automatorwp-webhooks-samples-dialog .automatorwp-webhooks-samples-options').append(
                                '<div class="automatorwp-webhooks-sample-option">'
                                    + '<input type="radio" id="sample-' + sample.id + '" name="sample" value="' + sample.id + '" ' + ( parseInt(i) === 0 ? 'checked="checked"' : '' ) + '/>'
                                    + '<div class="automatorwp-webhooks-sample-data-toggle">'
                                        + '<span class="dashicons dashicons dashicons-arrow-down-alt2"></span>'
                                    + '</div>'
                                    + '<label for="sample-' + sample.id + '">Hook ' + letters.charAt(i) + '</label>'
                                    + '<div class="automatorwp-webhooks-sample-data" style="display: none;">'
                                        + sample_data_html
                                    + '</div>'
                                + '</div>'
                            );
                        });

                        // Setup the current options form to be used on save
                        current_form = button.closest('.automatorwp-option-form-container');;

                        // Show dialog with options
                        $('.automatorwp-webhooks-samples-dialog').dialog({
                            dialogClass: 'automatorwp-dialog',
                            show: { effect: 'fadeIn', duration: 400 },
                            hide: { effect: 'fadeOut', duration: 200 },
                            resizable: false,
                            height: 'auto',
                            width: 600,
                            modal: true,
                            draggable: false
                        });

                        // Empty response wrap
                        response_wrap.html('');

                        // Enable button
                        button.prop('disabled', false);

                    } else {
                        // Samples not found

                        var start_time = button.data('start');
                        var now = new Date();

                        // Check if get samples has exceeded the 60 seconds
                        if( ( now.getTime() - start_time ) <= 60000 ) {

                            // If not has exceeded, get samples again (delayed in 1 second)
                            setTimeout( automatorwp_webhooks_get_samples, 1000, button );

                        } else {

                            // Show no samples found message
                            response_wrap.html('<div class="automatorwp-notice-error">' + automatorwp_webhooks_admin.no_samples_found + '</div>');

                            // Enable button
                            button.prop('disabled', false);

                        }

                    }

                } else {
                    // In case of error, show the message received and enable the button

                    // Show response
                    response_wrap.html('<div class="automatorwp-notice-error">' + response.data + '</div>');

                    // Enable button
                    button.prop('disabled', false);
                }

            },
            error: function( response ) {

                // Show response
                response_wrap.html('<div class="automatorwp-notice-error">' + response.data + '</div>');

                // Enable button
                button.prop('disabled', false);

            }
        });

    }

    // Click toggle data
    $('body').on('click', '.automatorwp-webhooks-sample-data-toggle', function(e) {

        // Slide toggle the sample data
        $(this).parent().find('.automatorwp-webhooks-sample-data').slideToggle('fast');

        // Switch toggle icon class
        var icon_element = $(this).find('.dashicons');

        if( icon_element.hasClass('dashicons-arrow-down-alt2') ) {
            icon_element.removeClass('dashicons-arrow-down-alt2').addClass('dashicons-arrow-up-alt2');
        } else {
            icon_element.removeClass('dashicons-arrow-up-alt2').addClass('dashicons-arrow-down-alt2');
        }
    });

    // Confirm samples
    $('body').on('click', '.automatorwp-webhooks-samples-confirm', function(e) {

        // Setup vars
        var dialog = $(this).closest('.automatorwp-webhooks-samples-dialog');
        var option = dialog.find('.automatorwp-webhooks-sample-option input:checked');

        // Reset current fields
        current_form.find('.cmb2-id-fields .cmb-repeatable-grouping:not(:first)').remove();

        var add_row_button = current_form.find('.cmb2-id-fields .cmb-repeatable-group button.cmb-add-group-row');

        option.parent().find('.automatorwp-webhooks-sample-data .automatorwp-webhooks-sample-data-field').each(function(index) {
            var field = $(this).data('field');

            // Add a new row
            if( index !== 0 ) {
                add_row_button.trigger('click');
            }

            // Set fields keys (type will remain on all as text)
            var last_group = current_form.find('.cmb2-id-fields .cmb-repeatable-grouping').last();

            last_group.find('input[data-option="fields[key]"]').val(field);
        });

        // Close dialog
        $('.automatorwp-webhooks-samples-dialog').dialog('close');
    });

    // Cancel samples
    $('body').on('click', '.automatorwp-webhooks-samples-cancel', function(e) {
        // Close dialog
        $('.automatorwp-webhooks-samples-dialog').dialog('close');
    });

    // Send test
    $('body').on('click', '.automatorwp-webhooks-send-test', function(e) {

        var button = $(this);

        if( button.prop('disabled') ) {
            return;
        }

        var form = button.closest('.automatorwp-option-form-container');
        var action_id = button.closest('.automatorwp-automation-item').find('input.id').val();
        var response_wrap = button.prev('.automatorwp-webhook-send-test-response');
        var data = automatorwp_get_option_form_values( form );

        // Url is required
        if( ! data.url.length ) {
            response_wrap.html('<div class="automatorwp-notice-error">' + automatorwp_webhooks_admin.url_error + '</div>');
            return false;
        }

        // Show spinner
        response_wrap.html('<span class="spinner is-active" style="margin-top: 9px; margin-bottom: 24px;"></span>');

        // Disable button
        button.prop('disabled', true);

        // Append the request data
        data.action = 'automatorwp_webhooks_send_test';
        data.nonce = automatorwp_webhooks_admin.nonce;
        data.action_id = action_id;

        $.ajax({
            url: ajaxurl,
            method: 'POST',
            data: data,
            success: function( response ) {

                // Show response
                response_wrap.html('<div class="automatorwp-notice-' + ( response.success ? 'success' : 'error' ) +'">' + response.data + '</div>');

                // Enable button
                button.prop('disabled', false);

            },
            error: function( response ) {

                // Show response
                response_wrap.html('<div class="automatorwp-notice-error">' + response.data + '</div>');

                // Enable button
                button.prop('disabled', false);

            }
        });

    });

    // On save or cancel option, empty responses
    $('body').on('click', '.automatorwp-save-option-form, .automatorwp-cancel-option-form', function(e) {

        var button = $(this);
        var form = button.closest('.automatorwp-option-form-container');

        // Empty responses
        form.find('.automatorwp-webhook-get-samples-response, .automatorwp-webhook-send-test-response').html('');

    });

})( jQuery );