<?php

/**
 * Ajax Functions
 *
 * @package     AutomatorWP\UserFeedback\Ajax_Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if (!defined('ABSPATH')) exit;

/**
 * Ajax function for selecting forms
 *
 * @since 1.0.0
 */
function automatorwp_userfeedback_ajax_get_surveys()
{
    check_ajax_referer('automatorwp_admin', 'nonce');

    global $wpdb;

    // Pull back the search string
    $search = isset($_REQUEST['q']) ? $wpdb->esc_like(sanitize_text_field($_REQUEST['q'])) : '';

    $lists = automatorwp_userfeedback_get_surveys();

    // Parse list results to match select2 results
    foreach ($lists as $list) {

        if (!empty($search)) {
            if (strpos(strtolower($list['name']), strtolower($search)) === false) {
                continue;
            }
        }

        $results[] = array(
            'id' => $list['id'],
            'text' => $list['title']
        );
    }

    // Prepend option none
    $results = automatorwp_ajax_parse_extra_options($results);

    // Return our results
    wp_send_json_success($results);
    die;
}
add_action('wp_ajax_automatorwp_userfeedback_get_surveys', 'automatorwp_userfeedback_ajax_get_surveys');
