<?php
/**
 * Custom Tables
 *
 * @package     AutomatorWP\User Lists\Custom_Tables
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

require_once AUTOMATORWP_USER_LISTS_DIR . 'includes/custom-tables/user-lists.php';
require_once AUTOMATORWP_USER_LISTS_DIR . 'includes/custom-tables/user-lists-users.php';

/**
 * Register all custom database Tables
 *
 * @since   1.0.0
 *
 * @return void
 */
function automatorwp_user_lists_register_custom_tables() {

    // User Lists
    ct_register_table( 'automatorwp_user_lists', array(
        'singular' => __( 'User List', 'automatorwp-pro' ),
        'plural' => __( 'User Lists', 'automatorwp-pro' ),
        'show_ui' => true,
        'show_in_rest' => true,
        'rest_base' => 'automatorwp-pro',
        'version' => 1,
        'capability' => automatorwp_get_manager_capability(),
        //'supports' => array( 'meta' ),
        'views' => array(
            'list' => array(
                'menu_title' => __( 'User Lists', 'automatorwp-pro' ),
                'parent_slug' => 'automatorwp',
                'admin_bar' => true,
                'admin_bar_parent' => 'automatorwp-add-ons',
            ),
        ),
        'schema' => array(
            'id' => array(
                'type' => 'bigint',
                'length' => '20',
                'auto_increment' => true,
                'primary_key' => true,
            ),
            'name' => array(
                'type' => 'text',
            ),
        ),
    ) );

    // User Lists > User
    ct_register_table( 'automatorwp_user_lists_users', array(
        'singular' => __( 'User Lists Users', 'automatorwp-pro' ),
        'plural' => __( 'User Lists Users', 'automatorwp-pro' ),
        'show_ui' => true,
        'show_in_rest' => false,
        'rest_base' => 'automatorwp-user-lists-user',
        'version' => 1,
        'capability' => automatorwp_get_manager_capability(),
        //'supports' => array( 'meta' ),
        'views' => array(
            'list' => array(
                'show_in_menu' => false,
            ),
        ),
        'schema' => array(
            'id' => array(
                'type' => 'bigint',
                'length' => '20',
                'auto_increment' => true,
                'primary_key' => true,
            ),
            'list_id' => array(
                'type' => 'bigint',
                'length' => '20',
                'key' => true,
            ),
            'user_id' => array(
                'type' => 'bigint',
                'length' => '20',
                'key' => true,
            ),
        ),
    ) );

}
add_action( 'ct_init', 'automatorwp_user_lists_register_custom_tables' );