<?php
/**
 * All Users List
 *
 * @package     AutomatorWP\Integrations\WordPress\Automations\All_Users_List
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_All_Users_List_Automation extends AutomatorWP_Automation_Loop {

    public $integration = 'user_lists';
    public $type = 'all-users-list';

    public function register() {

        // Automation type args
        $this->args = array(
            'image' => AUTOMATORWP_USER_LISTS_URL . 'assets/img/automatorwp-all-users-list-logo.svg',
            'label' => __( 'All users in list', 'automatorwp-pro' ),
            'desc'  => __( 'Run actions on users from a User List.', 'automatorwp' ),
            // Automation loop specific args
            'labels' => array(
                'singular' => __( 'User', 'automatorwp-pro' ),
                'plural' => __( 'Users', 'automatorwp-pro' ),
            ),
            'required_trigger' => 'user_lists_all_users_list',
        );
    }

    public function process_items( $items_ids, $automation, $trigger, $trigger_options ) {

        global $automatorwp_event;

        // Set up a false event since the following functions require it
        $automatorwp_event = array(
            'user_id' => 0
        );

        foreach ( $items_ids as $items_id ) {

            $user_id = absint( $items_id );
            $automatorwp_event['user_id'] = $user_id;

            foreach( $trigger_options as $option => $value ) {
                // Replace all tags by their replacements
                $trigger_options[$option] = automatorwp_parse_automation_tags( $automation->id, $user_id, $value );
            }

            // Check if user deserves the trigger filters
            if( ! automatorwp_user_deserves_trigger_filters( $trigger, $user_id, $automatorwp_event, $trigger_options, $automation ) ) {
                continue;
            }

            // Execute all automation actions
            automatorwp_execute_all_automation_actions( $automation, $user_id, $automatorwp_event );

        }

    }

}

new AutomatorWP_All_Users_List_Automation();