<?php
/**
 * Ajax Functions
 *
 * @package     AutomatorWP\Integrations\Twitter\Ajax_Functions
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Handler to save OAuth credentials
 *
 * @since 1.0.0
 */
function automatorwp_twitter_ajax_save_oauth_credentials() {

    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    $prefix = "automatorwp_twitter_";

    /* sanitize incoming data */
    $consumer_key = sanitize_text_field( $_POST["consumer_key"] );
    $consumer_secret = sanitize_text_field( $_POST["consumer_secret"] );
    $access_token = sanitize_text_field( $_POST["access_token"] );
    $access_token_secret = sanitize_text_field( $_POST["access_token_secret"] );

    if( $consumer_key == '' && $consumer_secret == '' && $access_token == '' && $access_token_secret == '' ) {
        // return error one of the field is missing
        wp_send_json_error();
    } else {
        try {
            $twitter = new Twitter( $consumer_key, $consumer_secret, $access_token, $access_token_secret );
            $credentials = get_option( 'automatorwp_settings' );

            if ( ! $twitter->authenticate() ) {

                $credentials[$prefix . 'consumer_key'] = null;
                $credentials[$prefix . 'consumer_secret'] = null;
                $credentials[$prefix . 'access_token'] = null;
                $credentials[$prefix . 'access_token_secret'] = null;
                $credentials[$prefix . 'access_valid'] = false; 
                $credentials = array_filter( $credentials );

                update_option( 'automatorwp_settings', $credentials );

                // Return error if invalid credentials
                wp_send_json_error();

            } else {
                
                $credentials[$prefix . 'consumer_key'] = $consumer_key;
                $credentials[$prefix . 'consumer_secret'] = $consumer_secret;
                $credentials[$prefix . 'access_token'] = $access_token;
                $credentials[$prefix . 'access_token_secret'] = $access_token_secret;
                $credentials[$prefix . 'access_valid'] = true;
                $credentials = array_filter( $credentials );

                update_option( 'automatorwp_settings', $credentials );

                // Twitter credentials verified
                wp_send_json_success();
            }

        } catch(Exception $e) {
            wp_send_json_error();
        }
    }

}
add_action( 'wp_ajax_automatorwp_twitter_save_oauth_credentials', 'automatorwp_twitter_ajax_save_oauth_credentials' );

/**
 * Handler to delete OAuth credentials
 *
 * @since 1.0.0
 */
function automatorwp_twitter_ajax_delete_oauth_credentials() {

    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    $prefix = "automatorwp_twitter_";
    $credentials = get_option( 'automatorwp_settings' );

    $credentials[$prefix . 'consumer_key'] = null;
    $credentials[$prefix . 'consumer_secret'] = null;
    $credentials[$prefix . 'access_token'] = null;
    $credentials[$prefix . 'access_token_secret'] = null;
    $credentials[$prefix . 'access_valid'] = false;
    $credentials = array_filter( $credentials );

    update_option( 'automatorwp_settings', $credentials );

    wp_send_json_success();

}
add_action( 'wp_ajax_automatorwp_twitter_delete_oauth_credentials', 'automatorwp_twitter_ajax_delete_oauth_credentials' );