(function ( $ ) {
    
    var _prefix = 'automatorwp_twitter_';

    // Save credentials
    $(document).on('click', '#automatorwp_save_twitter_oauth', function( e ) {

        e.preventDefault();

        var button = $(this);
        var wrapper = button.parent();

        // Check if response div exists
        var status_wrap = wrapper.find('#awp_twitter_oauth_status');

        var data = {
            action: 'automatorwp_twitter_save_oauth_credentials',
            nonce: automatorwp_twitter.nonce,
            consumer_key: $('#' + _prefix + 'consumer_key').val(),
            consumer_secret: $('#' + _prefix + 'consumer_secret').val(),
            access_token: $('#' + _prefix + 'access_token').val(),
            access_token_secret: $('#' + _prefix + 'access_token_secret').val(),
        };

        $.post(ajaxurl, data, function (response ) {
            if( response.success ) {
                status_wrap.css("width", "fit-content");
                status_wrap.addClass( 'automatorwp-notice-success' );
                status_wrap.html( 'Credentials Saved!' );
                status_wrap.slideDown('fast');
            } else {
                if (data.consumer_key.length == 0 || data.consumer_secret.length == 0 || data.access_token.length == 0 || data.access_token_secret.length == 0 ) {
                    status_wrap.css("width", "fit-content");
                    status_wrap.addClass( 'automatorwp-notice-error' );
                    status_wrap.html( 'All fields are required to connect with Twitter' );
                    status_wrap.slideDown('fast');
                } else {
                    status_wrap.css("width", "fit-content");
                    status_wrap.addClass( 'automatorwp-notice-error' );
                    status_wrap.html( 'Either Credentials are invalid or Twitter API is not accessible' );
                    status_wrap.slideDown('fast');
                }
            }
        });
      
    });

    // Delete credentials
    $(document).on('click', '#automatorwp_remove_twitter_oauth', function( e ) {

        e.preventDefault();

        $( '#awp_twitter_oauth_status' ).text( "Removing Credentials...(wait)" );

        var data = {
            action: 'automatorwp_twitter_delete_oauth_credentials',
            nonce: automatorwp_twitter.nonce,
        };

        $.post(ajaxurl, data, function (response ) {
            $( '#awp_twitter_oauth_status' ).text( "Credentials Removed! Refresh this page. " );
            setTimeout(function () { location.reload(); }, 100);
        });

    });

    // Tweet character count
    $(document).on('keydown keyup change', '.cmb2-id-tweet textarea', function( e ) {
        var char_count = $(this).val().length;
        var char_count_element = $(this).parent().find('.automatorwp-twitter-char-count');

        char_count_element.html( char_count );

        if( char_count > 280 ) {
            char_count_element.css('color', '#f00');
        } else {
            char_count_element.css('color', '');
        }
    });

})( jQuery );